dnl Copyright (C) 1993-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels.

AC_PREREQ(2.13)

AC_DEFUN([CL_GETHOSTBYNAME],
[AC_REQUIRE([CL_NETDB])dnl
if test $ac_cv_header_netdb_h = yes; then
  have_netdb=1
else
  AC_CHECK_HEADER(sun/netdb.h, have_netdb=1)
fi
if test -n "$have_netdb"; then
AC_DEFINE(HAVE_GETHOSTBYNAME)
CL_PROTO([gethostbyname], [
CL_PROTO_CONST([
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#ifdef HAVE_NETDB_H
#include <sys/socket.h>
#include <netdb.h>
#else
#include <sun/netdb.h>
#endif
], [struct hostent * gethostbyname (char* name);],
[struct hostent * gethostbyname();],
cl_cv_proto_gethostbyname_arg1)
], [extern struct hostent * gethostbyname ($cl_cv_proto_gethostbyname_arg1 char*);])
AC_DEFINE_UNQUOTED(GETHOSTBYNAME_CONST,$cl_cv_proto_gethostbyname_arg1)
fi
])
