/*
     spar - Show Process Accounting Records
     Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.

users.c - 10/28/93

*/
#include <stdio.h>
#include <pwd.h>

#include "config.h"

struct uidcache {
     char *name;
     uid_t uid;
};

struct uidcache ucache[8192];

static int uc_init = 0;

int
cgetuidname(char *name, unsigned long *uid)
{
     struct passwd *pwent;
     int hash;

     if(!uc_init){
	  (void)memset((void *)ucache, 0, sizeof(ucache));
	  uc_init = 1;
     }

     if((pwent = getpwnam(name))){
	  *uid = pwent->pw_uid;
	  hash = (*uid) & 8191;
	  ucache[hash].uid = *uid;
	  if(!ucache[hash].name)
	       ucache[hash].name = (char *)malloc(9);
	  (void)strncpy(ucache[hash].name, name, 8);
	  ucache[hash].name[8] = 0;
	  return 0;
     }
     return -1;
}

char *
cgetnamuid(uid_t uid)
{
     struct passwd *pwent;
     int hash = uid & 8191;

     if(!uc_init){
	  (void)memset((void *)ucache, 0, sizeof(ucache));
	  uc_init = 1;
     }

     if(ucache[hash].name && ucache[hash].uid == uid){
	  return ucache[hash].name;
     }
     else if((pwent = getpwuid(uid))){
	  if(!ucache[hash].name)
	       ucache[hash].name = (char *)malloc(9);
	  (void)strcpy(ucache[hash].name, pwent->pw_name);
	  ucache[hash].uid = uid;
     }
     else {
	  if(!ucache[hash].name)
	       ucache[hash].name = (char *)malloc(9);
	  (void)sprintf(ucache[hash].name, "%8lu", (unsigned long)uid);
	  ucache[hash].uid = uid;
     }
     return ucache[hash].name;
}
