/*
     spar - Show Process Accounting Records
     Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.

tty.c - 10/28/93

*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>

#include "config.h"

#ifndef NODEV
# define NODEV (short)0xffff
#endif

struct devcache {
     char *name;
     dev_t dev;
};

struct devcache ttycache[8192];

static int dc_init = 0;

static char *locatetty(dev_t);

int
cgetttyname(char *tty, unsigned long *dev)
{
     char namebuf[256], *nbuf;
     struct stat buf;

     if(!dc_init){
	  (void)memset((void *)ttycache, 0, sizeof(ttycache));
	  dc_init = 1;
     }

     if(strcasecmp(tty, "notty") == 0){
	  *dev = NODEV;
	  return 0;
     }

     if(tty[0] == '/')
	  nbuf = tty;
     else {
	  (void)sprintf(namebuf, "/dev/%s", tty);
	  nbuf = namebuf;
     }

     if(stat(nbuf, &buf) != -1){
	  int hash, majd, mind;
	  *dev = buf.st_rdev;
	  majd = (int)MAJORDEV(buf.st_rdev);
	  mind = (int)MINORDEV(buf.st_rdev);
	  hash = (int)((majd<<6)+mind) & 8191;
	  if(!ttycache[hash].name){
	       ttycache[hash].name = (char *)malloc(32);
	       (void)strncpy(ttycache[hash].name, nbuf, 31);
	       ttycache[hash].name[31] = 0;
	       ttycache[hash].dev = buf.st_rdev;
	  }
	  return 0;
     }
	  
     return -1;
}

char *
cgetnametty(dev_t dev)
{
     int hash;
     char *name;
     int majd, mind;

     if(dc_init == 0){
	  (void)memset((void *)ttycache, 0, sizeof(ttycache));
	  dc_init = 1;
     }

     if(dev == NODEV){
	  return "<notty>";
     }

     majd = (int)MAJORDEV(dev);
     mind = (int)MINORDEV(dev);
     hash = (int)((majd<<6)+mind) & 8191;

     if(ttycache[hash].name && ttycache[hash].dev == dev){
	  return ttycache[hash].name;
     }
     else {

	  if(!ttycache[hash].name)
	       ttycache[hash].name = (char *)malloc(32);

	  if((name = locatetty(dev))){
	       (void)strncpy(ttycache[hash].name, name, 31);
	       ttycache[hash].name[31] = 0;
	       ttycache[hash].dev = dev;
	  }
	  else {
	       (void)sprintf(ttycache[hash].name, "tty:%d.%d", majd, mind);
	       ttycache[hash].dev = dev;
	  }
     }

     return ttycache[hash].name;
}

static char *misctty[] = { MISCTTY };

static char *
locatetty(dev_t dev)
{
     int majd, mind;
     static char bufname[256];
     struct stat statbuf;
     static char *c = "pqrstuvwxyz";
     static char *hex ="0123456789abcdef";
     static char *tlets = "abcdefghijklmnopqrstuvwxyz";
     int p1, p2;
     int i;

     majd = (int) MAJORDEV(dev);
     mind = (int) MINORDEV(dev);

#ifdef SYSVPTY
     (void)sprintf(bufname, "%s/%d", SYSVPTY, mind);

     if(stat(bufname, &statbuf) != -1){
	  if(statbuf.st_rdev == dev)
	       return bufname;
     }
#endif

#ifdef SYSVMPTY
     if(stat(SYSVMPTYC, &statbuf) != -1){
	  if(MAJORDEV(statbuf.st_rdev) == majd){
	       sprintf(bufname, "%s/%d", SYSVMPTY, mind);
	       return bufname;
	  }
     }
#endif

#ifdef BSDPTY
     p1 = (mind & 0xf0) >> 4;
     p2 = (mind & 0x0f);
     (void)sprintf(bufname, "%s/tty%c%c", BSDTTY, c[p1], hex[p2]);
     if(stat(bufname, &statbuf) != -1){
	  if(statbuf.st_rdev == dev)
	       return bufname;
     }
#endif

#ifdef SYSVTTY
     if(mind < 26){
	  (void)sprintf(bufname, "%s/%c", SYSVTTY, tlets[mind]);
	  if(stat(bufname, &statbuf) != -1){
	       if(statbuf.st_rdev == dev)
		    return bufname;
	  }
     }
     (void)sprintf(bufname, "%s/%d", SYSVTTY, mind);
     if(stat(bufname, &statbuf) != -1){
	  if(statbuf.st_rdev == dev)
	       return bufname;
     }
#endif

#ifdef BSDTTY
     (void)sprintf(bufname, "%s/ttyd%d", BSDTTY, mind);
     if(stat(bufname, &statbuf) != -1){
	  if(statbuf.st_rdev == dev)
	       return bufname;
     }

     if(mind < 26){
	  (void)sprintf(bufname, "%s/tty%d", BSDTTY, mind);
	  if(stat(bufname, &statbuf) != -1){
	       if(statbuf.st_rdev == dev)
		    return bufname;
	  }
	  (void)sprintf(bufname, "%s/tty%c", BSDTTY, tlets[mind]);
	  if(stat(bufname, &statbuf) != -1){
	       if(statbuf.st_rdev == dev)
		    return bufname;
	  }
     }
#endif
     if(stat("/dev/console", &statbuf) != -1){
	  if(statbuf.st_rdev == dev)
	       return "/dev/console";
     }

     for(i=0;misctty[i];i++){
	  if(stat(misctty[i], &statbuf) != -1)
	       if(statbuf.st_rdev == dev)
		    return misctty[i];
     }
     return 0;
}
