/*
     spar - Show Process Accounting Records
     Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.

timesub.c - 03/20/93

*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <sys/acct.h>
#include "config.h"
#include "timesub.h"
#include "ldiv.h"

#define MICPSEC 1000000

extern time_t time(time_t *);

unsigned long clockrate = 0;

void
setclockrate(void)
{
     clockrate = CLKRATE;
}

int
getyear(void)
{
     time_t t;
     struct tm *tmb;

     t = time(0);

     tmb = localtime(&t);

     return tmb->tm_year;
}

unsigned long
makedate(int month, int mday, int year)
{
     struct tm tmbuf;

     tmbuf.tm_isdst = -1;
     tmbuf.tm_sec = 0;
     tmbuf.tm_min = 0;
     tmbuf.tm_hour = 0;
     tmbuf.tm_mday = mday;
     tmbuf.tm_mon = month - 1;
     tmbuf.tm_year = year-1900;
     tmbuf.tm_wday = 0;
     tmbuf.tm_yday = 0;
     return mktime(&tmbuf);
}

unsigned long
timeofday(unsigned long sofday, int hour, int min, int sec)
{
     struct tm *tmb;
     struct tm tmbuf;
     time_t tsday = sofday;
     tmb = localtime(&tsday);
     (void)memcpy((void *)&tmbuf, (void *)tmb, sizeof(struct tm));

     tmbuf.tm_isdst = -1;
     tmbuf.tm_hour = hour;
     tmbuf.tm_min = min;
     tmbuf.tm_sec = sec;
     return mktime(&tmbuf);
}

unsigned long
today(void)
{
     time_t t;
     struct tm *tmb;
     struct tm tmbuf;

     t = time(0);

     tmb = localtime(&t);
     (void)memcpy((void *)&tmbuf, (void *)tmb, sizeof(struct tm));

     tmbuf.tm_isdst = -1;
     tmbuf.tm_sec = 0;
     tmbuf.tm_min = 0;
     tmbuf.tm_hour = 0;
     return mktime(&tmbuf);
}

unsigned long
yesterday(void)
{
     time_t t;
     struct tm *tmb;
     struct tm tmbuf;

     t = time(0);

     tmb = localtime(&t);
     (void)memcpy((void *)&tmbuf, (void *)tmb, sizeof(struct tm));

     tmbuf.tm_isdst = -1;
     tmbuf.tm_sec = 0;
     tmbuf.tm_min = 0;
     tmbuf.tm_hour = 0;
     tmbuf.tm_mday--;
     tmbuf.tm_yday--;
     tmbuf.tm_wday=0;
     return mktime(&tmbuf);
}

static
int daycnts[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
     
int
validmday(int month, int mday, int year)
{
     int febdays = 28;

     if(month != 2)
	  return mday > 0 && mday <= daycnts[month-1];
     if(!(year % 4) && (!(year % 100) || year % 400))
	  febdays = 29;

     return mday > 0 && mday <= febdays;
}

char *
gettimestr(struct timeval tp)
{
     struct tm *tm;
     static char buf[50];

     tm = localtime(&tp.tv_sec);

     if(tm->tm_year > 99){
	  sprintf(buf, "%02d/%02d/%04d %02d:%02d:%02d",
		  tm->tm_mon+1,
		  tm->tm_mday,
		  tm->tm_year+1900,
		  tm->tm_hour,
		  tm->tm_min,
		  tm->tm_sec);
     }
     else {
	  sprintf(buf, "%02d/%02d/%02d %02d:%02d:%02d",
		  tm->tm_mon+1,
		  tm->tm_mday,
		  tm->tm_year,
		  tm->tm_hour,
		  tm->tm_min,
		  tm->tm_sec);
     }
     return buf;
}

#define SECPERMIN 60
#define MINPERHOUR 60
#define HOURPERDAY 24
#define SECPERHOUR (SECPERMIN*MINPERHOUR)
#define SECPERDAY (SECPERHOUR*HOURPERDAY)

char *
getelapsed(unsigned long ticks)
{
     unsigned long seconds = 0, minutes = 0, hours = 0, days = 0;
     static char buf[50];
     ldiv_t divrem;

     seconds = fromticks(ticks);

     if(seconds >= SECPERDAY){
	  divrem = ldiv((long)seconds, (long)SECPERDAY);
	  days = divrem.quot;
	  seconds = divrem.rem;
     }
     if(seconds >= SECPERHOUR){
	  divrem = ldiv((long)seconds, (long)SECPERHOUR);
	  hours = divrem.quot;
	  seconds = divrem.rem;
     }
     if(seconds >= SECPERMIN){
	  divrem = ldiv((long)seconds, (long)SECPERMIN);
	  minutes = divrem.quot;
	  seconds = divrem.rem;
     }
     
     if(days)
	  (void)sprintf(buf, "%lu+%02lu:%02lu:%02lu",
			days, hours, minutes, seconds);
     else
	  (void)sprintf(buf, "%02lu:%02lu:%02lu", hours, minutes, seconds);

     return buf;
}

char *
getelapsed2(unsigned long ticks)
{
     unsigned long seconds = 0, minutes = 0, hours = 0, days = 0;
     static char buf[50];
     ldiv_t divrem;

     seconds = fromticks(ticks);

     if(seconds >= SECPERDAY){
	  divrem = ldiv((long)seconds, (long)SECPERDAY);
	  days = divrem.quot;
	  seconds = divrem.rem;
     }
     if(seconds >= SECPERHOUR){
	  divrem = ldiv((long)seconds, (long)SECPERHOUR);
	  hours = divrem.quot;
	  seconds = divrem.rem;
     }
     if(seconds >= SECPERMIN){
	  divrem = ldiv((long)seconds, (long)SECPERMIN);
	  minutes = divrem.quot;
	  seconds = divrem.rem;
     }
     
     if(days)
	  (void)sprintf(buf, "%lu+%02lu:%02lu:%02lu",
			days, hours, minutes, seconds);
     else if(hours)
	  (void)sprintf(buf, "%02lu:%02lu:%02lu", hours, minutes, seconds);
     else
	  (void)sprintf(buf, "%02lu:%02lu", minutes, seconds);

     return buf;
}
