/* MEM.C - memory allocation module for Miro ambiguity checker

   $Header: mem.c,v 1.5 91/07/30 18:52:54 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon

   IMPLEMENTATION NOTES

   This memory allocation module is implemented in a naive way using the
   standard malloc() and free() UNIX routines. As a result, the InitMem()
   and ShutDownMem() routines are unnecessary.
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <stdio.h>
#include <string.h>
#include <my-types.h>

#include "mem.h"

/* LOCAL VARIABLES ======================================================== */

#ifdef DEBUG

/* total amount of memory alloc'ed by the program */
static ULint mem_used;
#endif

/* GLOBAL FUNCTIONS ======================================================= */

void InitMem()
{
#ifdef DEBUG
    mem_used = 0L;
#endif DEBUG
}

Generic *AllocBlock(size)
  unsigned size;
{
    char *result;
    extern char *malloc();

    if ((result=malloc(size)) == NULL) {
	perror("malloc");
	exit(1);
    }
#ifdef DEBUG
    mem_used += size;
#endif DEBUG
    return((Generic *)result);
}

void FreeBlock(ptr)
  Generic *ptr;
{
    free((char *)ptr);
}

void ShutDownMem()
{
#ifdef DEBUG
    fprintf(stderr,"\nTotal memory used: %u.\n",mem_used);
#endif DEBUG
}
