%{
/* $Header: iff.l,v 1.5 91/07/20 17:04:51 heydon Exp $

   Lex source file for parsing Miro picture files in IFF format. See
   Miro Note #4 for a description of IFF. This parsing file works in
   conjunction with the yacc file "iff.y".
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <strings.h>
#include <my-types.h>
#include "mem.h"
#include <my-defs.h>

#include "parser.h"
#include "parser.g"
#include "iff.y.h"

#define YYLVAL_UNION
#include <yacc-globals.h>

/* LOCAL FUNCTIONS ======================================================== */

static char conv_C_char(s)
  char *s;
{
  int val;
  switch (*s) {
    case 'n': return('\n');
    case 't': return('\t');
    case 'b': return('\b');
    case 'r': return('\r');
    case 'f': return('\f');
    case '\\': return('\\');
    case '\'': return('\'');
    default:
	if (*s >= '0' && *s <= '7') {
		val = (*s++ - '0');
		while (*s) val = val * 8 + (*s++ - '0');
		return((char)val);
	}
	else return(*s);
  }
}
%}
WHITECHAR	[ \t]
TOKEN		([a-zA-Z][-_?a-zA-Z0-9]*)
INTTOKEN	[+-]?[0-9]+
SINGLECHAR	[>;={},]
COMMENT		"#"
COMMENTSTART	"/*"
COMMENTEND	"*/"
%START		SINGLECOMMENT MULTICOMMENT INSTRING STRINGESCAPE
%%
%{
static int comment_level=0;
static char *my_str;
%}
%{
  /* ======================== QUOTED STRINGS ========================== */
%}
%{
  /* Read string, looking for termination char '"' or string escape char '\'.
  */ 
%}
<INSTRING>[^"\\]*["\\]			{
					  (void)strcpy(my_str,yytext);
					  my_str += (yyleng-1);
					  if (*my_str == '"') {
					    *my_str = '\0';
					    BEGIN 0;
					    CopyString
					      (yylval.string_val,
					       quoted_string);
					    return(STRING);
					  }
					  else {   /* ends with '\\' */
					    BEGIN STRINGESCAPE;
					  }
					}
%{
  /* Handle line continuation within a string. If a string escape '\' has just
   * occurred and it is followed by either: 1) blank or tab 2) newline, then
   * absorb all chars to the end of the line and any other whitespace on the
   * *start* of the next line.
  */
%}
<STRINGESCAPE>([ \t].*)?\n{WHITECHAR}*	{
					  BEGIN INSTRING;
					  curr_line_no++;
					}
%{
  /* Handle C-style character constant escapes within a string. If a string
   * escape '\' has just occurred not followed by a whitespace character, call
   * the function conv_C_char() to convert the sequence to a character.
  */
%}
<STRINGESCAPE>([^ \t\n]|[0-7]{1,3})	{
					  *my_str++ = conv_C_char(yytext);
					  BEGIN INSTRING;
					}
%{
  /* Catch (and absorb) start of string.
  */
%}
\"					{
					  my_str = quoted_string;
					  BEGIN INSTRING;
					}
%{
  /* ============================= COMMENTS ============================= */
%}
%{
  /* Start single-line '#' comments.
  */
%}
{COMMENT}				{
					  BEGIN SINGLECOMMENT;
					}
%{
  /* Absorb the rest of the '#' comment.
   *
   * Note: The '#' comment processing is divided into two phases so that
   * strings starting with a '#' character will not be interpretted as
   * comments. This works because the previous rule has a match at most 1
   * character long. Since the string-matching rule must match at least that
   * many characters and appears earlier in the file, it will gobble the '#'
   * as part of a string.
  */
%}
<SINGLECOMMENT>.*\n			{
					  curr_line_no++;
					  BEGIN 0;
					}
%{
  /* When in comments, absorb any chars which could not possibly break the
   * comment up.
  */
%}
<MULTICOMMENT>[^\n/*]*			;
%{
  /* Within comment, catch (and absorb) start of nested comment.
  */
%}
<MULTICOMMENT>{COMMENTSTART}		{ /* RULE (B) */
					  comment_level++;
					}
%{
  /* Within comment, catch (and absorb) end of currently nested comment.
  */
%}
<MULTICOMMENT>{COMMENTEND}			{
					  if (--comment_level == 0)
					    BEGIN 0;
					}
%{
  /* Absorb "\n", "/", or "*" by themselves within a comment.
  */
%}
<MULTICOMMENT>[\n/*]			{
					  if (yytext[0] == '\n')
					    curr_line_no++;
					}
%{
  /* Catch (and absorb) first comment; start <MULTICOMMENT> mode.
   *
   * Note: This regexp must come after rule (B) so (B) will match "/*" before
   * this rule if already in a comment.
  */
%}
{COMMENTSTART}				{
					  comment_level++;
					  BEGIN MULTICOMMENT;
					}
%{
  /* ======================= TOKENS/WHITESPACE ========================= */
%}
%{
  /* Recognize single-character tokens in the grammar.
  */
%}
{SINGLECHAR}				{
					  return(yytext[0]);
					}
%{
  /* Absorb whitespace.
  */
%}
{WHITECHAR}+				;
%{
  /* Absorb newlines.
  */
%}
\n					{
					  curr_line_no++;
					}
%{
  /* Recognize integers.
  */
%}
{INTTOKEN}				{
					  yylval.int_val = atoi(yytext);
					  return(INTEGER);
					}
%{
  /* Absorb any other tokens.
  */
%}
{TOKEN}					{
                                          yylval.id_val = yytext;
                                          return(IDENTIFIER);
					}
%%
