/* ERROR.C -- error-reporting functions.

   $Header: error.c,v 1.4 91/07/30 19:18:28 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <stdio.h>
#include <my-types.h>
#include "mem.h"
#include <my-defs.h>

#include "error.h"
#include "parser.h"
#include "parser.g"

/* LOCAL FUNCTIONS ======================================================== */

static void ParseErrorHeader(line_no)
  int line_no;
{
    fprintf(stderr,"%5d: ",line_no);
    parse_error_cnt++;
}

static void ProgrammerErrorHeader(file_name)
  String file_name;
{
    fprintf(stderr,"programmer error: %s\n\t",file_name);
}

/* GLOBAL FUNCTIONS ======================================================= */

void ParseError(line_no,template)
  int line_no;
  char *template;
{
    ParseErrorHeader(line_no);
    fprintf(stderr,template);
    fprintf(stderr,"\n");
}

void ParseErrorI(line_no,template,int_val)
  int line_no;
  char *template;
  int int_val;
{
    ParseErrorHeader(line_no);
    fprintf(stderr,template,int_val);
    fprintf(stderr,"\n");
}

void ParseErrorS(line_no,template,string_val)
  int line_no;
  char *template;
  String string_val;
{
    ParseErrorHeader(line_no);
    fprintf(stderr,template,string_val);
    fprintf(stderr,"\n");
}

void ParseErrorSS(line_no,template,s_val1,s_val2)
  int line_no;
  char *template;
  String s_val1,s_val2;
{
    ParseErrorHeader(line_no);
    fprintf(stderr,template,s_val1,s_val2);
    fprintf(stderr,"\n");
}

void yyerror(error_msg)
  String error_msg;
{
    ParseErrorHeader(curr_line_no);
    fprintf(stderr,"%s\n",error_msg);
}

void ProgrammerErrorI(file_name,template,int_val)
  String file_name;
  char *template;
  int int_val;
{
    ProgrammerErrorHeader(file_name);
    fprintf(stderr,template,int_val);
    fprintf(stderr,"\n");
    exit(-2);
}
