
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

#include <stdio.h>
#include "errors.h"
#include "list_type.h"

#define DEF_WHITE_SPACE " \t\n\r\b\f"
#define DEF_OPEN_CHARS "({["
#define DEF_CLOSE_CHARS ")}]"

pargs (pargc, pargv, pwhite_space, popen_chars, pclose_chars)
int *pargc;
char ***pargv;
char **pwhite_space, **popen_chars, **pclose_chars;{

/* Check the argument list for switches; switches must be the first
   arguments to the function, hence all filenames must appear after
   switches. */

    while ((*pargc) > 1 && **++(*pargv) == '-') {
	switch (*(*(*pargv) + 1)) {
	    case 'w':
	        *pwhite_space = *(*pargv) + 2;
	        break;
	    case 'o':
	        *popen_chars = *(*pargv) + 2;
	        break;
	    case 'c':
	        *pclose_chars = *(*pargv) + 2;
	        break;
	    default:
	        fprintf (stderr, "Unknown switch '%c'\n",
			*(*(*pargv) + 1));
	        break;
	} /* switch */
	(*pargc)--;
    } /* while */
} /* pargs */

main (argc, argv)
int argc;
char *argv[];
{
    FILE *fp, *fopen ();
    char buf[10000];		/* For the text of atoms */
    char *prog = *argv, *ptr = buf, *empty ();
    char *white_space = DEF_WHITE_SPACE;
    char *open_chars = DEF_OPEN_CHARS;
    char *close_chars = DEF_CLOSE_CHARS;
    list_type lis;
    int parse_val;

    einit ();

    pargs (&argc, &argv, &white_space, &open_chars, &close_chars);

    if (argc == 1) {
	while (!feof (stdin)) {
	    printf ("\nEnter a LISP list: ");
	    parse_val = fp2list (stdin, &lis, &ptr, white_space, open_chars,
		    close_chars, stdout);
	    printf ("Parse returned '%d', list follows:\n", parse_val);
	    print_list (stdout, lis, empty);
	} /* while */
    } else
	while (--argc) {
	    if ((fp = fopen (*argv, "r")) == NULL)
		fprintf (stderr, "%s:  can't open %s\n", prog, *argv);
	    else {
		printf ("\n\tFile %s being read\n\n", *argv);
		parse_val = fp2list (fp, &lis, &ptr, white_space, open_chars,
			close_chars, stdout);
		printf ("Parse returned '%d', list follows:\n", parse_val);
		print_list (stdout, lis, empty);
		fclose (fp);
	    } /* else */
	} /* while */
} /* main */



char *empty (x, y, depth, num, fp)
list_type x;
boolean y;
int depth, num;
FILE *fp;
{
    return (char *) x;
} /* empty */
