
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

#include <stdio.h>
#include "mwm.h"
#include "list_type.h"

#define TESTING(x,y) printf ("\nNow testing x:\n"), y ()
#define TEST(x,y) printf ("x ==> "), print_list (stdout, x, empty), printf \
	("\tshould be %s\n", (char *) y)
#define ITEST(x,y) printf ("x ==> %d\n\tshould be %d\n", x, y)

list_type one = (list_type) "one";
list_type two = (list_type) "two";
list_type three = (list_type) "three";
list_type four = (list_type) "four";

main ()
{
    list_type a, im, hello;
    char *one, *two;
    int string_equal ();
    char *empty ();

    one = "Hello,";
    two = "World.";
    im = (list_type) "I'm";
    hello = (list_type) one;

    einit ();
    a = cons (two, nil);
    a = cons (one, a);
    TEST (a, "(Hello, World.)");
    TEST (car (a), one);
    TEST (cadr (a), two);
    a = cons (cons ("I'm", cons ("in C", nil)), a);
    TEST (a, "((I'm in C) Hello, World.)");
    TEST (assoc (im, a, string_equal), "(I'm in C)");
    TEST (assoc (hello, a, string_equal), "nil");

    TESTING (ASSOC, assoc_test);
    TESTING (ATOM, atom_test);
    TESTING (CADAR, cadar_test);
    TESTING (CAR, car_test);
    TESTING (CDR, cdr_test);
    TESTING (CONS, cons_test);
    TESTING (LISTP, listp_test);
    TESTING (NULL, null_test);

    TESTING (LAST, last_test);
    TESTING (LENGTH, length_test);
    TESTING (LIST_COPY, lc_test);
    TESTING (MEMBER, member_test);
    TESTING (PAIRLIS, pairlis_test);
    TESTING (REVERSE, reverse_test);
    TESTING (RPLACA, rplaca_test);
    TESTING (RPLACD, rplacd_test);
    TESTING (SUBST, subst_test);
} /* main */

boolean string_equal (a, b)
char *a, *b;
{
    return !strcmp (a, b);
} /* string_equal */

char *empty (x, y, depth, item_num, fp)
list_type x;
boolean y;
int depth, item_num;
FILE *fp;
{
    return (char *) x;
} /* empty */

assoc_test ()
{
    list_type a;

    a = cons ( cons (one, cons ("1", nil)), cons (cons (two, cons ("2",
	    nil)), cons (cons (three, cons ("3", nil)), nil)));
    TEST (a, "((one 1) (two 2) (three 3))");
    TEST (assoc (one, a, string_equal), "(one 1)");
    TEST (assoc (cons (one, nil), a, string_equal), "nil");
    TEST (assoc (three, a, string_equal), "(three 3)");
    TEST (assoc (one, nil, string_equal), "nil");
    TEST (assoc (one, cons (nil, nil), string_equal), "nil");
} /* assoc_test */



atom_test ()
{
    list_type at, lis;

    at = (list_type) "atom";
    lis = cons ((list_type) "lis", nil);
    TEST (at, "atom");
    TEST (lis, "(lis)");
    ITEST (atom (at), 1);
    ITEST (atom (lis), 0);
    ITEST (atom (nil), 1);
    ITEST (atom (cons (nil, nil)), 0);
} /* atom_test */



cadar_test ()
{
    list_type a;

    a = cons (cons (cons (one, cons (two, nil)), cons (cons (two, cons
	    (three, nil)), cons (three, nil))), cons (four, nil));
    TEST (a, "(((one two) (two three) three) four)");
    TEST (cadar (a), "(two three)");
    TEST (cadar (cdr (a)), "nil");
    ITEST (cadar (cdr (a)), PASTNIL);
} /* cadar_test */



car_test ()
{
    list_type a;

    a = cons (one, nil);
    TEST (a, "(one)");
    TEST (car (a), "one");
    TEST (car (one), "nil");
    ITEST (car (one), PASTNIL);
    a = cons (cons (two, nil), a);
    TEST (a, "((two) one)");
    TEST (car (a), "(two)");
} /* car_test */

cdr_test ()
{
    list_type a;

    a = cons (one, nil);
    TEST (a, "(one)");
    TEST (cdr (a), "nil");
    TEST (cdr (one), "nil");
    ITEST (cdr (one), PASTNIL);
    a = cons (cons (two, nil), a);
    TEST (a, "((two) one)");
    TEST (cdr (a), "(one)");
} /* cdr_test */



cons_test ()
{
    printf ("How the heck can you test CONS?\n");
} /* cons_test */



listp_test ()
{
    list_type a;

    a = cons (one, cons (two, cons (three, cons (four, nil))));
    TEST (a, "(one two three four)");
    ITEST (listp (a), 1);
    ITEST (listp (nil), 1);
    ITEST (listp (one), 0);
    ITEST (listp (cddddr (a)), 1);
    ITEST (listp (cons (one, two)), 1);
} /* listp_test */



null_test ()
{
    list_type a;

    a = cons (one, cons (two, nil));
    TEST (a, "(one two)");
    ITEST (null (a), 0);
    ITEST (null (nil), 1);
    ITEST (null (cddr (a)), 1);
    ITEST (null (cdr (a)), 0);
    ITEST (null (one), 0);
} /* null_test */

last_test ()
{
    list_type a;

    a = cons (cons (cons (one, cons (two, nil)), cons (two, cons (three,
	    nil))), cons (two, cons (three, cons (four, nil))));
    TEST (a, "(((one two) two three) two three four)");
    TEST (last (a), "(four)");
    TEST (last (cdr (a)), "(four)");
    TEST (last (car (a)), "(three)");
    TEST (last (caar (a)), "(two)");
    TEST (cdaar (a), "(two)");
    TEST (last (cdaar (a)), "(two)");
    TEST (last (caaar (a)), "one");
    TEST (last (one), "one");
    TEST (last (nil), "nil");
    ITEST (last (nil), nil);
} /* last_test  */



length_test ()
{
} /* length_test */



lc_test ()
{
} /* lc_test */



member_test ()
{
} /* member_test */



pairlis_test ()
{
} /* pairlis_test */



reverse_test ()
{
} /* reverse_test */



rplaca_test ()
{
} /* rplaca_test */



rplacd_test ()
{
} /* rplacd_test */



subst_test ()
{
} /* subst_test */


