/* YACC-GLOBALS.H

   $Header: yacc-globals.h,v 1.1 90/10/18 16:05:44 heydon Exp $

   Written by Allan Heydon.

   This is a header file for C source files which are compiled separately
   from the yacc(1) source file but do make use of the yacc(1) global
   variables. For example, lex(1) source files which are compiled separ-
   ately will want to use this file. This is done by using the "-d" switch
   when the yacc source file is compiled, producing a file called "y.tab.h"
   and putting '#include "y.tab.h"' in the first section of the lex source
   file (inside lines starting with %{ and %} respectively).
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


/* YYLVAL_UNION should be #defined iff a %union{} declaration is used in the
   yacc source file to define the possible types yylval can take on; the
   default is to declare yylval to be an int.
*/
#ifndef YYLVAL_UNION
extern int yylval;		/* an extra value returned by the lexer */
#endif

extern int yychar;		/* token number of lookahead token at error
				   time */
extern int yydebug;		/* if non-zero, parser outputs verbose
				   description of its actions */

extern void yyerror();		/* default error handling routine; takes
				   string (char *) as argument */
