/* PARSER.G -- Definitions of global variables for the parser.[ch] module.

   $Header: parser.g,v 1.3 91/05/08 15:08:49 heydon Locked $

   Written by Allan Heydon for the Miro project at Carnegie Mellon

   The first two of these global variables are necessary because global
   variables are the only way to pass information back from a YACC module.
   Information is also passed in to the YACC module via the global variable
   'yyin', which should be set to the input FILE * to be read.
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef PARSER_G
#define PARSER_G

#include "error.h"

/* GLOBAL VARIABLES FOR THIS MODULE ======================================= */

/* number of errors encountered during the parse */
extern int parse_error_cnt;

/* line number of input file; incremented by lex code */
extern int curr_line_no;

/* buffer used to store a quoted string read by the lex code */
extern char quoted_string[];

#endif PARSER_G
