
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

/* MY-DEFS.H -- generic #defines that may be useful in many programs

   $Header: my-defs.h,v 1.14 91/08/22 00:44:49 heydon Exp $

   Written by Allan Heydon

   Note: The memory allocation functions depend on the macro MALLOC. This
   should be the name of the primitive funtion to allocate bytes of memory. If
   it is undefined, the default behavior is that MALLOC is defined to "malloc".

   OVERVIEW OF THIS MODULE

   WHAT THIS MODULE PROVIDES

   This module provides the following FUNCTIONS:
      AllocOne()      - Allocate one item of a particular type.
      AllocArray()    - Allocate an array of some number of items of a
                        particular type.
      AllocPtrArray() - Allocate an array of some number of pointers to items
                        of some type.
*/

#ifndef MY_DEFS_H
#define MY_DEFS_H

#include <strings.h>

#ifndef NULL
#define NULL 0
#endif

/* STRUCTURE ACCESS FUNCTIONS ============================================= */

#define NextOf(_struct_ptr) ((_struct_ptr)->next)

/* LINKED LIST FUNCTIONS ================================================== */

#define Next(_struct_ptr)\
    (_struct_ptr)=(_struct_ptr)->next

#define SpliceIntoList(_head,_new)\
    NextOf(_new) = (_head);\
    (_head) = (_new)

#define StepInitializedLinkedList(_struct_ptr)\
    for (; (_struct_ptr)!=NULL; Next(_struct_ptr))

#define StepLinkedList(_struct_ptr,_init)\
    for ((_struct_ptr)=(_init); (_struct_ptr)!=NULL; Next(_struct_ptr))

#define StepPtrLinkedList(_pp,_init)\
    for ((_pp)=(&(_init)); *(_pp)!=NULL; (_pp)=(&((*(_pp))->next)))

#define	StepIndex(_var,_init,_upper)\
    for ((_var)=(_init); (_var)<(_upper); (_var)++)

#define StepIndexBackwards(_var,_lower,_upper)\
    for ((_var)=(_upper)-1; (_var)>=(_lower); (_var)--)

#define StepPtrArray(_var,_init)\
    for ((_var)=(_init); *(_var); (_var)++)

/* MEMORY ALLOCATION FUNCTIONS ============================================ */

#ifndef MALLOC
#define MALLOC malloc
#define FREE free
extern char *malloc();
extern int free();
#endif

#ifdef MACRO_FUNCTION
d_type *AllocOne( /* Type d_type */ );
/* Allocate one item of Type 'd_type', and RETURN a pointer to that item.
*/
#endif MACRO_FUNCTION

#define AllocOne(_d_type)\
    (_d_type *)MALLOC((unsigned)sizeof(_d_type))

#ifdef MACRO_FUNCTION
d_type *AllocArray( /* Type d_type, int num */ );
/* Allocate an array of 'num' items of Type 'd_type', and RETURN a pointer to
   the first item in the array.
*/
#endif MACRO_FUNCTION

#define AllocArray(_d_type,_num)\
    (_d_type *)MALLOC((unsigned)((_num) * sizeof(_d_type)))

#ifdef MACRO_FUNCTION
d_type **AllocPtrArray( /* Type d_type, int num */ );
/* Allocate an array of 'num' pointers to items of Type 'd_type', and RETURN
   a pointer to the first pointer in the array. Note: Only the pointers are
   allocated by this routine, and not the actual items themselves.
*/
#endif MACRO_FUNCTION

#define AllocPtrArray(_d_type,_num)\
    (_d_type **)MALLOC((unsigned)((_num) * sizeof(_d_type *)))

#ifdef MACRO_FUNCTION
void Dealloc( /* ANY *ptr */ );
/* De-allocate the memory allocated at '*ptr' by previous calls to
   AllocBlock(), AllocArray(), or AllocPtrArray().
*/
#endif MACRO_FUNCTION

#define Dealloc(_ptr)\
    (void)FREE((Generic *)_ptr)

/* STRING FUNCTIONS ======================================================= */

/* Correct bug in puts(3), which always appends a newline */
#define MyPuts(_string)\
    (void)fputs(_string,stdout)

/* Allocate space using malloc(3) and copy a string */
#define CopyString(_to,_from)\
    (_to) = MALLOC((unsigned)(strlen(_from)+1));\
    (void)strcpy(_to,_from)

/* DATA MANIPULATION FUNCTIONS ============================================ */

/* Swap two values (using a temporary container) */
#define Swap(_a,_b,_tmp)\
    (_tmp) = (_a); (_a) = (_b); (_b) = (_tmp);

/* Max/Min macros */
#define Max(_a,_b) (((_a) > (_b)) ? (_a) : (_b))
#define Min(_a,_b) (((_a) < (_b)) ? (_a) : (_b))

/* PAMETER MODIFIER MACROS ================================================ */

#define OUT   /* Out Parameter */
#define INOUT /* InOut Parameter */

/* ERROR-CHECKING/HANDLING FUNCTIONS ====================================== */

/* Assert(expr) -- If 'expr' is zero, prints an error message to stdout and
   causes program termination.

   To use: compile the program with ASSERT defined. This can be done by
   specifying "-DASSERT" on the cc(1) command line.
*/

#ifdef ASSERT
#define Assert(_expr)\
    if (!(_expr)) { fputs("ERROR: Assertion failed!\n",stderr); exit(-2); }
#else
/* evaluate expr in case it has side-effects */
#define Assert(_expr) (_expr)
#endif ASSERT

#endif
