
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

#ifndef LIST_TYPE
#define LIST_TYPE

#include "mwm.h"		    /* need the   boolean   data type */

#define nil ((list_type) -1024)     /* Both   nil and PASTNIL   must be
				       distinct from ALL other atoms */
#define PASTNIL ((list_type) -1023)


#define assoc(x,y,z) assoc_hlp ((list_type) (x), (list_type) (y), (z))
#define atom(x) (!consp (x))
#define car(x) (!atom (_DUMMY = (x)) ? (list_type) _DUMMY -> car_elt : \
	(eprintf (_car_error, _DUMMY), PASTNIL))
#define cdr(x) (!atom (_DUMMY = (x)) ? (list_type) _DUMMY -> cdr_elt : \
	(eprintf (_cdr_error, _DUMMY), PASTNIL))
#define cons(x,y) cons_hlp ((int *) (x), (int *) (y))
#define delete(val,lis,fcn) delete_help ((list_type) (val), &(lis), (fcn))
#define insert(val,lis,fcn) insert_help ((list_type) (val), &(lis), (fcn))
#define listp(x) (null (_DUMMY = (x)) || consp (_DUMMY))
#define null(x) (((_DUMMY = (x)) == nil) || (_DUMMY == PASTNIL))
#define printf_list print_list		/* I've made the mistake too often */


#define caar(x) car (car (x))
#define cadr(x) car (cdr (x))
#define cdar(x) cdr (car (x))
#define cddr(x) cdr (cdr (x))
#define caaar(x) car (car (car (x)))
#define caadr(x) car (car (cdr (x)))
#define cadar(x) car (cdr (car (x)))
#define caddr(x) car (cdr (cdr (x)))
#define cdaar(x) cdr (car (car (x)))
#define cdadr(x) cdr (car (cdr (x)))
#define cddar(x) cdr (cdr (car (x)))
#define cdddr(x) cdr (cdr (cdr (x)))
#define caaaar(x) car (car (car (car (x))))
#define caaadr(x) car (car (car (cdr (x))))
#define caadar(x) car (car (cdr (car (x))))
#define caaddr(x) car (car (cdr (cdr (x))))
#define cadaar(x) car (cdr (car (car (x))))
#define cadadr(x) car (cdr (car (cdr (x))))
#define caddar(x) car (cdr (cdr (car (x))))
#define cadddr(x) car (cdr (cdr (cdr (x))))
#define cdaaar(x) cdr (car (car (car (x))))
#define cdaadr(x) cdr (car (car (cdr (x))))
#define cdadar(x) cdr (car (cdr (car (x))))
#define cdaddr(x) cdr (car (cdr (cdr (x))))
#define cddaar(x) cdr (cdr (car (car (x))))
#define cddadr(x) cdr (cdr (car (cdr (x))))
#define cdddar(x) cdr (cdr (cdr (car (x))))
#define cddddr(x) cdddr_hlp (cdr (x))

typedef struct {
    int *car_elt, *cdr_elt;
} cell_type;

typedef cell_type *list_type;

void print_list (/* FILE *, list_type, char *(*) () */);
void free_cons (/* list_type */);
void free_list (/* list_type */);
void fmultout (/* FILE *, int, char */);
boolean consp (/* list_type */);
int length (/* list_type */);
list_type append (/* list_type, list_type */);
list_type assoc_hlp (/* list_type, list_type, boolean (*) () */);
list_type caxr (/* list_type, int */);
list_type cdxr (/* list_type, int */);
list_type cons_hlp (/* int *, int * */);
void delete_help (/* list_type, list_type *, boolean (*) () */);
list_type flatten (/* list_type */);
void insert_help (/* list_type, list_type *, boolean (*) () */);
list_type last (/* list_type */);
list_type list_copy (/* list_type */);
list_type member (/* list_type, list_type, boolean (*) () */);
list_type cdddr_hlp (/* list_type */);
list_type nconc (/* list_type, list_type */);
list_type pairlis (/* list_type, list_type */);
list_type reverse (/* list_type */);
list_type rplaca (/* list_type, list_type */);
list_type rplacd (/* list_type, list_type */);
list_type subst (/* list_type, list_type, list_type, boolean (*) () */);

static list_type _DUMMY;
static char *_car_error = "car:  tried to take   car   of atom '%d'\n";
static char *_cdr_error = "cdr:  tried to take   cdr   of atom '%d'\n";

#endif LIST_TYPE
