
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

#include <stdio.h>
#include <strings.h>		/* for strcmp(3) */
#include "list_type.h"
#include "vf.h"

/* BUG BUG BUG  The Warn and MustWarn routines will also write to stderr,
   no matter what vf_log points to.  That's fine, but there are some cases
   (notably when access permissions differ in verbose mode) that not all
   of the vf_log text also gets written to stderr.  In that example, it's
   because the write_perms routine is used, and it only writes to one
   file, it doesn't check for stderr like the Warn routines do.
*/

extern int group_errors, group_error_max, quiet;
extern char *this_program;

/*VARARGS1*/
GroupError (a, b, c, d, e, f, g, h, i, j, k, l)
char *a, *b, *c, *d, *e, *f, *g, *h, *i, *j, *k, *l;
{
    if (group_errors++ < group_error_max)
	MustWarn (a, b, c, d, e, f, g, h, i, j, k, l);
    else if (group_errors == group_error_max + 1)
	MustWarn (
	  "%s:  MORE THAN %d ERRORS IN GROUP FILE, no more will be output.\n",
		this_program, group_error_max);
    else
	group_errors = group_error_max + 1;
} /* GroupError */



/*VARARGS1*/
MatrixError (a, b, c, d, e, f, g, h, i, j, k, l)
char *a, *b, *c, *d, *e, *f, *g, *h, *i, *j, *k, *l;
{
    static int matrix_errors = 0;
    static int matrix_error_max = 100;

    if (matrix_errors++ < matrix_error_max)
	MustWarn (a, b, c, d, e, f, g, h, i, j, k, l);
    else if (matrix_errors == matrix_error_max + 1)
	MustWarn (
  "%s:  MORE THAN %d ERRORS IN ACCESS LIST FILE, no more will be output.\n",
		this_program, matrix_error_max);
    else
	matrix_errors = matrix_error_max + 1;
} /* MatrixError */



/* WarnAmbigPerm -- warn the user that one of the permission names given
   in an input file (prober.out or ambig.perms) is ambiguous, i.e. matches
   two or more of the names given in the permissions file.  We'll only
   output one warning for each violation.

	warn -- permission name from the input file
	this, that -- permission names from the permissions file
*/

WarnAmbigPerm (warn, this, that)
char *warn, *this, *that;
{
    static list_type done = nil;

    if (!quiet && !member((list_type) warn, done, strcmp)) {
	Warn ("%s:  WARNING!! Input permission '%s' is ambiguous ",
		this_program, warn);
	Warn ("(e.g., could be '%s' or '%s')\n", this, that);
	done = cons ((list_type) warn, done);
    } /* if !quiet */
} /* WarnAmbigPerm */


/* WarnNoPerm -- Tell the user that the given permission name could not be
   found in the permissions file database (it's either missing or
   ambiguous) */

WarnNoPerm (perm, desc)
char *perm, *desc;
{
    static list_type done = nil;

    if (!quiet && !member((list_type) perm, done, strcmp)) {
	Warn ("%s:  WARNING!! Permission '%s' in %s could not be",
		this_program, perm);
	Warn (" resolved, skipping\n");
	done = cons ((list_type) perm, done);
    } /* if !quiet */
} /* WarnNoPerm */


/* InternalWarn -- warn the developer about unexpected (but nonfatal)
   states. */

/*VARARGS1*/
InternalWarn (str, a, b, c, d, e, f, g, h, i, j, k, l, m)
char *str, *a, *b, *c, *d, *e, *f, *g, *h, *i, *j, *k, *l, *m;
{
    if (!quiet)
	fprintf (stderr, str, a, b, c, d, e, f, g, h, i, j, k, l, m);
} /* InternalWarn */


/* MustWarn -- a warning message that cannot be ignored, even in quiet
   mode */

/*VARARGS1*/
MustWarn (str, a, b, c, d, e, f, g, h, i, j, k, l, m)
char *str, *a, *b, *c, *d, *e, *f, *g, *h, *i, *j, *k, *l, *m;
{
    fprintf (vf_log, str, a, b, c, d, e, f, g, h, i, j, k, l, m);
    if (vf_log != stderr)
	fprintf (stderr, str, a, b, c, d, e, f, g, h, i, j, k, l, m);
} /* MustWarn */


/* Warn -- a warning message that can safely be ignored, e.g. in quiet
   mode. */

/*VARARGS1*/
Warn (str, a, b, c, d, e, f, g, h, i, j, k, l, m)
char *str, *a, *b, *c, *d, *e, *f, *g, *h, *i, *j, *k, *l, *m;
{
    if (!quiet) {
	fprintf (vf_log, str, a, b, c, d, e, f, g, h, i, j, k, l, m);
	if (vf_log != stderr)
	    fprintf (stderr, str, a, b, c, d, e, f, g, h, i, j, k, l, m);
    } /* if !quiet */
} /* Warn */
