/* fp2list.c

	Program by:  Mark Maimone 6/12/86
	Last Modified:  6/18/86

	11-Jan-91 (ky) Modified to ignore line comments.

	25-Nov-90 (mwm)  Modified to allocate identifier strings via the
   StackMemoryT ADT.  This not only allows allows an essentially unlimited
   number of identifiers, but also allows the storage to be reclaimed
   quite easily.  I apologize for dredging up this old code, but I needed
   something to parse in the input file, and lex seemed like too much
   overkill (plus I'm not really up on linking multiple instantiations of
   lex together into one main routine).

*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <stdio.h>
#include <strings.h>
#include "errors.h"
#include "list_type.h"
#include "util.h"		/* for StackMemoryT */

#define strchr index

#define DIAGNOSTIC if (diagnostic_output) fprintf (diagnostic_output,

void skip_white_space ();
list_type parse_atom ();
int parse_list ();


/* fp2list -- Returns 1 if successful, 0 on end of file, -1 if error */

int fp2list (fp, result, strbuf, stack, white_space, open_chars, close_chars,
	     linecomment_chars, diagnostic_output)
FILE *fp;		/* File containing the text to be parsed */
list_type *result;	/* Pointer to the location in which the parse
			   value will be stored (i.e. a VAR parameter) */
char *strbuf;		/* Pointer to the one-word buffer area */
StackMemoryT **stack;	/* Main identifier storage */
char *white_space;	/* String containing all white space characters */
char *open_chars;	/* String containing all list opening characters,
			   e.g. (, {, [, in 1-1 correspondence with .... */
char *close_chars;	/* String containing all list closing characters,
			   e.g. ), }, ] */
char *linecomment_chars; /* String containing all characters that can */
			 /* start a line comment, e.g. ; */
FILE *diagnostic_output;
{
    char *ptr, c;
    int ret_val, my_index;

    skip_white_space (fp, white_space, linecomment_chars);
    if (feof (fp))
	return 0;

    c = getc (fp);

    if ((ptr = strchr (close_chars, c)) != NULL) {

	DIAGNOSTIC "Closing char '%c' read too soon\n", c);
	ret_val = -1;

    } else if ((ptr = strchr (open_chars, c)) == NULL) {

	ungetc ((int) c, fp);
	*result = parse_atom (fp, strbuf, stack, white_space, open_chars,
			      close_chars);
	ret_val = 1;

    } else {	/* Must be an opening character */

	my_index = ptr - open_chars;
	skip_white_space (fp, white_space,linecomment_chars);
	ret_val = parse_list (fp, result, close_chars[my_index], strbuf, stack,
			      white_space, open_chars, close_chars,
			      linecomment_chars, diagnostic_output);
    } /* else */

    return ret_val;
} /* fp2list */

/* parse_atom -- copy the string from   fp   into   strbuf,   updating
   strbuf   and stopping when a white space, opening or closing character
   is read.  ASSUMPTION:  the first character in   fp   will be contained
   in the atom. */

list_type parse_atom (fp, strbuf, stack, white_space, open_chars,
                      close_chars)
FILE *fp;
char *strbuf;
StackMemoryT **stack;
char *white_space, *open_chars, *close_chars;
{
    register char c;
    register char *ptr = strbuf;

    while (!strchr (white_space, (c = getc (fp))) && !strchr (open_chars, c)
	   && !strchr (close_chars, c) && !feof (fp))
	*ptr++ = c;

    *ptr++ = '\0';
    ungetc ((int) c, fp);
    ptr = st_alloc (stack, strlen (strbuf) + 1);
    strcpy (ptr, strbuf);
    return (list_type) ptr;
} /* parse_atom */

/* parse_list -- ASSUMPTION:  first char is not white space */

int parse_list (fp, result, end_char, strbuf, stack, white_space, open_chars,
		close_chars, linecomment_chars, diagnostic_output)
FILE *fp;
list_type *result;
char end_char;		/* Character which will terminate this list */
char *strbuf;
StackMemoryT **stack;
char *white_space, *open_chars, *close_chars, *linecomment_chars;
FILE *diagnostic_output;
{
    register char c;
    int ret_val;
    list_type temp;

    c = getc (fp);
    if (c == end_char) {
	*result = nil;
	ret_val = 1;
    } else if (strchr (close_chars, c)) {
	*result = nil;		/* The logic behind this assignment is not
				   well planned, so beware */
	DIAGNOSTIC "Mismatched delimeters; expected '%c', got '%c'\n",
		end_char, c);
	ret_val = -1;
    } else {
	ungetc ((int) c, fp);
	if ((ret_val = fp2list (fp, result, strbuf, stack, white_space,
				open_chars, close_chars, linecomment_chars,
				diagnostic_output)) > 0) {
	    skip_white_space (fp, white_space, linecomment_chars);
	    ret_val = parse_list (fp, &temp, end_char, strbuf, stack,
				  white_space, open_chars, close_chars,
				  linecomment_chars, diagnostic_output);
	    if (ret_val > 0)
		*result = cons (*result, temp);
	} /* if */
    } /* else */

    return ret_val;
} /* parse_list */

void skip_white_space (fp, white_space, linecomment_chars)
FILE *fp;
char *white_space, *linecomment_chars;
{
    register char c;

    while (!feof(fp)){
      c = getc(fp);
      if (strchr (linecomment_chars, c)){
	while (!feof(fp) && ((c = getc(fp)) != '\n'));
      }else if (!strchr(white_space,c)) break;
    } /* while */

    ungetc ((int) c, fp);
} /* skip_white_space */
