
/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/

#include "hash.h"

/* Tables.h -- Declares routines and defines macros used by the prober to
   access the UserID and GroupID symbol tables

$Header: Tables.h,v 1.1 90/11/27 23:13:27 mwm Exp $

$Log:	Tables.h,v $
 * Revision 1.1  90/11/27  23:13:27  mwm
 * Initial revision
 * 
 * Revision 1.1  90/09/11  13:36:57  mwm
 * Initial revision
 * 

*/

/*  GroupInfoT -- data to associate with a group number, including the
   group's name, description bits (is this group NEEDED, WANTED, or was it
   CREATED), and the list of users */

typedef struct {
    char *name;
    int flags;
    HashTableT *users;
} GroupInfoT;

/* StringInfoT -- data to associate with a user number, including the text
   login ID, and any description bits */

typedef struct {
    char *name;
    int flags;
} StringInfoT;

/* IntInfoT -- data to associate with a login ID, or a group ID; all we
   need is the corresponding number */

typedef struct {
    int num;
} IntInfoT;

/* hash2 macros:  given the address of a hash table entry ((key,value)
   pair),  skip over the key and return the address of the value */

#define hash2groupinfo(x) ((GroupInfoT *)  ((char *)(x) + sizeof (int *)))
#define hash2strinfo(x)	  ((StringInfoT *) ((char *)(x) + sizeof (int *)))
#define hash2intinfo(x)	  ((IntInfoT *)    ((char *)(x) + sizeof (char *)))
#define hash2userhash(x)  (hash2groupinfo (x) -> users)

/* Values to associate with user and group ID flags */

#define ID_NEEDED	01	/* This ID was not in the original list,
				   but must be considered to get a
				   complete picture of the filesystem */
#define ID_WANTED	02	/* This ID was in one of the input files,
				   users or groups   */
#define ID_CREATED	04	/* There was no entry in the system passwd
				   (group) file for this user (group)
				   number, so a dummy string was created */

#define MarkNeed(x) ((x) -> flags |= ID_NEEDED)
#define MarkWant(x) ((x) -> flags |= ID_WANTED)
#define MarkCreated(x) ((x) -> flags |= ID_CREATED)

/* Reverse mappings -- given a name, return the corresponding number, and
   vice versa */

#define uname2num(name) (lookup_res = Lookup (us2n, (char *) (name)), \
	(lookup_res && !Empty (lookup_res, (char *) &zerop, sizeof (char *))) \
	? (&(hash2intinfo (lookup_res) -> num)) : (int *) NULL)
#define unum2info(num) (lookup_res = Lookup (un2s, (char *) (num)), \
	(lookup_res && !Empty (lookup_res, (char *) &bad_id, sizeof (int))) \
	? hash2strinfo (lookup_res) : (StringInfoT *) NULL)
#define unum2name(num) (lookup_res = (char *) unum2info (num), lookup_res ? \
	((StringInfoT *) lookup_res) -> name : (char *) NULL)
#define gname2num(name) (lookup_res = Lookup (gs2n, (char *) (name)), \
	(lookup_res && !Empty (lookup_res, (char *) &zerop, sizeof (char *))) \
	? (&(hash2intinfo (lookup_res) -> num)) : (int *) NULL)
#define gnum2info(num) (lookup_res = Lookup (gn2i, (char *) (num)), \
	(lookup_res && !Empty (lookup_res, (char *) &bad_id, sizeof (int))) \
	? hash2groupinfo (lookup_res) : (GroupInfoT *) NULL)

#define MAX_GROUP_IDENT_LEN 100	/* Max length of a single group identifier
				   */
#define PASSWD_TABLES_TO_SAVE 2	/* Under the assumption that the prober
				   will be called several times during one
				   execution, this is the number of tables
				   to keep active between probes */


extern HashTableT *us2n, *un2s, *gs2n, *gn2i;


static char *lookup_res;	/* used in the name2num & num2name macros */

extern char *this_program;

/* FUNCTION DECLARATIONS */

char *int_print (), *info_print (), *str_print ();

