
;
;/*****************************************************************************
;                Copyright Carnegie Mellon University 1992
;
;                      All Rights Reserved
;
; Permission to use, copy, modify, and distribute this software and its
; documentation for any purpose and without fee is hereby granted,
; provided that the above copyright notice appear in all copies and that
; both that copyright notice and this permission notice appear in
; supporting documentation, and that the name of CMU not be
; used in advertising or publicity pertaining to distribution of the
; software without specific, written prior permission.
;
; CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
; ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
; CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
; ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
; WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
; ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
; SOFTWARE.
;*****************************************************************************/
;
(in-package 'miro)
(create-instance 'nested-popup-menu opal:aggregate
		 (:top 0)
		 (:left 0)
		 (:items nil)
		 (:selection-function nil)
		 (:title nil)
		 (:v-spacing 0)
		 (:h-align :left)
		 (:shadow-offset 5)
		 (:text-offset 4)
		 (:title-font
		  (create-instance nil opal:font
				   (:family :serif)
				   (:face :roman)))
		 (:item-font
		  (create-instance nil opal:font
				   (:family :serif)
				   (:face :bold)))
		 (:inactive-font
		  (create-instance nil opal:font
				   (:family :serif)
				   (:face :italic)))
		 (:inactive-list nil)
		 (:menu-active T)
		 (:waiting-priority inter:normal-priority-level)
		 (:running-priority inter:running-priority-level)
		 (:inactive-items nil)

		 (:visible nil)
		 (:top-menu nil)
		 (:sub-menus nil)
		 (:selected-menu nil)
		 (:value
		  (o-formula
		   (when (and (gvl :top-menu)
			      (gvl :top-menu :value))
			 (cons (gvl :top-menu :value)
			       (when (gvl :selected-menu)
				     (gvl :selected-menu
					  :value))))))
		 (:path-to-me nil)
		 )


(defun *nested-popup-menu-default-action* (obj nv)
  (let ((my-submenu (nth (position nv (g-value obj :items))
			 (g-value obj :parent :sub-menus)))
	(window (g-value obj :window))
	)
    (when window (opal:update window))
    (unless (and my-submenu (g-value my-submenu :visible))
	    (call-schema (g-value obj :parent) :run-action
			 (list nv)
			 (and
			  (not (position
				(append (g-value obj :parent :path-to-me)
					(list nv))
				(g-value obj :parent :inactive-list)
				:test #'equal))
			  (g-value obj :parent :menu-active)))
	    )))

(define-method :pop-up nested-popup-menu (obj left top)
  (s-value obj :visible T)
  (s-value obj :left left)
  (s-value obj :top top)
  (let ((window (g-value obj :window)))
    (when window (opal:update window))))

(define-method :pop-down nested-popup-menu (obj)
  (s-value obj :visible nil)
  (let ((window (g-value obj :window)))
    (when window (opal:update window))))

(define-method :run-action nested-popup-menu
  (obj new-value active)
  (let* ((rank (position (car new-value) (g-value obj :top-menu
						  :items)))
	 (actions (g-value obj :my-actions))
	 (parent (g-value obj :parent))
	 (action (nth rank actions))
	 (action-fn (if (functionp action) (when active action)
		      (if active (first action) (second action))))
	 (selection (g-value obj :selection-function))
	 (selection-fn (if (functionp selection)
			   (when active selection)
			 (if active (first selection)
			   (second selection))))
	 (window (g-value obj :window))
	 )
    (when window (opal:update window))
    (when action-fn (funcall action-fn obj new-value))
    (if (is-a-p parent nested-popup-menu)
	(call-schema parent :run-action
		     (cons (g-value parent :top-menu :value)
			   new-value) active)
      (when selection-fn (funcall selection-fn obj new-value)))
    (when active (call-schema obj :pop-down))
    ))

(define-method :activate-menu nested-popup-menu (obj)
  (unless (g-value obj :menu-active)
	  (s-value obj :menu-active T)))

(define-method :inactivate-menu nested-popup-menu (obj)
  (when (g-value obj :menu-active)
	(s-value obj :menu-active nil)))

(define-method :activate-item nested-popup-menu (obj item)
  (let* ((oitems (g-value obj :inactive-list))
	 (items (remove item oitems :test #'equal))
	 )
    (unless (equal items oitems)
	    (s-value obj :inactive-list items))
    )
  )

(define-method :inactivate-item nested-popup-menu (obj item)
  (pushnew item (g-value obj :inactive-list) :test #'equal)
  )

(define-method :initialize nested-popup-menu (obj)
  (call-prototype-method obj)
  (call-schema obj :notice-new-items))

(define-method :notice-new-items nested-popup-menu (obj)
  (let ((old-components (get-values obj :components))
	top-items top-actions sub-menus)

    ;; get rid of the old menus/submenus, if any
    (s-value obj :top-menu nil)
    (s-value obj :sub-menus nil)
    (dolist (c old-components)
	    (when (kr::schema-name c)
		  (opal:remove-component obj c)
		  (opal:destroy-me c)))

    ;; split the item list into items, actions, sub-menus
    (dolist (item (g-value obj :items))
	    (cond
	     ((and item (listp item))
	      (push (first item) top-items)
	      (push (second item) top-actions)
	      (push (third item) sub-menus)
	      )
	     (T (push item top-items)
		(push nil top-actions)
		(push nil sub-menus)
		)
	     ))
    (setf top-items (reverse top-items))
    (s-value obj :my-actions (setf top-actions (reverse top-actions)))
    (setf sub-menus (reverse sub-menus))

    ;; create the "top-level" menu
    (let ((top-menu
	   (create-instance
	    nil garnet-gadgets:menu
	    (:top (o-formula (gvl :parent :top)))
	    (:left (o-formula (gvl :parent :left)))
	    (:v-spacing (o-formula (gvl :parent :v-spacing)))
	    (:h-align (o-formula (gvl :parent :h-align)))
	    (:shadow-offset (o-formula (gvl :parent :shadow-offset)))
	    (:text-offset (o-formula (gvl :parent :text-offset)))
	    (:title (o-formula (gvl :parent :title)))
	    (:title-font (o-formula (gvl :parent :title-font)))
	    (:items top-items)
	    (:item-font (o-formula (gvl :parent :item-font)))
	    (:inactive-font (o-formula (gvl :parent :inactive-font)))
	    (:selection-function #'*nested-popup-menu-default-action*)
	    )))
      (s-value obj :top-menu top-menu)
      (s-value (g-value top-menu :selector) :waiting-priority
	       (o-formula (gvl :operates-on :parent :waiting-priority)))
      (s-value (g-value top-menu :selector) :running-priority
	       (o-formula (gvl :operates-on :parent :running-priority)))
      (opal:add-component obj top-menu)
      (dolist (i (get-values (g-value top-menu :menu-item-list) :components))
	      (s-value i :font
		       (o-formula
			(if (or (not (gvl :parent :parent :parent :menu-active))
				(position
				 (append (gvl :parent :parent :parent :path-to-me)
					 (list (gvl :string)))
				 (gvl :parent :parent :parent :inactive-list)
				 :test #'equal))
			    (gvl :parent :parent :inactive-font)
			  (gvl :parent :parent :item-font))))
	      )
      )

    ;; create the sub-menus
    (s-value obj :sub-menus
	     (mapcar
	      #'(lambda (item spec)
		  (declare (ignore item))
		  (when spec
			(create-instance
			 nil nested-popup-menu
			 (:my-position
			  (o-formula (position (gv :self)
					       (gvl :parent
						    :sub-menus))))
			 (:parent-item
			  (o-formula (nth (gvl :my-position)
					  (get-values
					   (gvl :parent :top-menu
						:menu-item-list)
					   :components))))
			 (:visible
			  (o-formula
			   (when (and (gvl :parent :visible)
				      (gvl :menu-active)
				      (not (position
					    (gvl :path-to-me)
					    (gvl :parent
						 :inactive-list)
					    :test #'equal)))
				 (let ((nv (eq (gvl :parent :top-menu
						    :value)
					       (gvl :parent-item
						    :string)))
				       (self kr::*schema-self*)
				       )
				   (if nv (s-value (g-value self :parent)
						   :selected-menu self)
				     (if (eq self
					     (g-value self :parent
						      :selected-menu))
					 (s-value (g-value self :parent)
						  :selected-menu nil)))
				   nv))))
			 (:path-to-me
			  (o-formula
			   (append (gvl :parent :path-to-me)
				   (list (gvl :parent-item
					      :string)))))
			 (:title nil)
			 (:left (o-formula
				 (-
				  (+ (gvl :parent-item :left)
				     (gvl :parent :top-menu :width))
				  (gvl :parent :shadow-offset))))
			 (:top (o-formula (gvl :parent-item :top)))
			 (:items spec)
			 (:v-spacing (o-formula (gvl :parent
						     :v-spacing)))
			 (:h-align (o-formula (gvl :parent :h-align)))
			 (:shadow-offset (o-formula
					  (gvl :parent
					       :shadow-offset)))
			 (:text-offset (o-formula
					(gvl :parent :text-offset)))
			 (:title-font (o-formula (gvl :parent
						      :title-font)))
			 (:item-font (o-formula (gvl :parent
						     :item-font)))
			 (:inactive-font (o-formula
					  (gvl :parent
					       :inactive-font)))
			 (:inactive-list (o-formula
					  (gvl :parent
					       :inactive-list)))
			 (:menu-active (o-formula (gvl :parent
						       :menu-active)))
			 (:waiting-priority
			  (o-formula (gvl :parent :waiting-priority)))
			 (:running-priority
			  (o-formula (gvl :parent :running-priority)))
			 )))
	      top-items sub-menus))
    (dolist (sm (g-value obj :sub-menus))
	    (when sm (opal:add-component obj sm)))
		      
    ))
