;;;             -*- Mode: Lisp; Package: MIRO; -*-
;
;/*****************************************************************************
;                Copyright Carnegie Mellon University 1992
;
;                      All Rights Reserved
;
; Permission to use, copy, modify, and distribute this software and its
; documentation for any purpose and without fee is hereby granted,
; provided that the above copyright notice appear in all copies and that
; both that copyright notice and this permission notice appear in
; supporting documentation, and that the name of CMU not be
; used in advertising or publicity pertaining to distribution of the
; software without specific, written prior permission.
;
; CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
; ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
; CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
; ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
; WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
; ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
; SOFTWARE.
;*****************************************************************************/
;

;;; 
;;; MIRO FONTS AND LINE STYLES
;;;

#|
============================================================
Change log:
    11/06/91 ky Created
============================================================
|#

(in-package "MIRO" :use `("LISP" "KR"))

;;;============================================================
;;; FONTS, LINE STYLES, CURSOR
;;;============================================================

;; make the dash for semantic arrows twice as long as
;; the default
(create-instance 'dash-ls opal:line-style
		 (:line-style :dash)
		 (:dash-pattern '(8 8)))

;;; use bitmap to get grey
(create-instance 'grey-bitmap opal:bitmap
		 (:image (opal:halftone-image 50)))


;;;------------------------------------------------------------
;;; CURSOR AND MASK
;;;------------------------------------------------------------
(create-instance 'miro-cursor opal:bitmap
		   (:image (opal:read-image
			    (find-on-path "miro-cursor.bm"
					  :lispfile nil))))

(create-instance 'miro-mask opal:bitmap
		   (:image (opal:read-image
			    (find-on-path "miro-mask.bm"
					  :lispfile nil))))

;;;============================================================
;;; *options* -- controls various editor behaviors.
;;;============================================================
(defun color-inverted () (> (g-value opal:black :red) 0.5))

(create-schema '*options*
	       ;; a function to reset the options to their default
	       ;; values.
	       (:use-default-values
		#'(lambda (&optional obj)
		    (declare (ignore obj))
		    (s-value *options* :change-background-for-dbox-emphasis nil)
		    (s-value *options* :large T)

		    ;; set the grays
		    (let ((black (g-value *options* :black))
			  (really-dark-gray (g-value *options*
						     :really-dark-gray))
			  (dark-gray (g-value *options* :dark-gray))
			  (medium-gray (g-value *options* :medium-gray))
			  (light-gray (g-value *options* :light-gray))
			  (really-light-gray (g-value *options*
						      :really-light-gray))
			  (white (g-value *options* :white)))
		      (dolist (color
			       (list
				(list black (g-value opal:black :red))
				(list really-dark-gray
				      (if (color-inverted) 0.95 0.4))
				(list dark-gray
				      (if (color-inverted) 0.9 0.5))
				(list medium-gray 0.7)
				(list light-gray
				      (if (color-inverted) 0.5 0.9))
				(list really-light-gray
				      (if (color-inverted) 0.4 0.95))
				(list white (g-value opal:white :red))))
			      (dolist (s '(:red :green :blue))
				      (s-value (first color) s
					       (second color)))
			      ))
		    ))
	       
	       ;; should we darken the background color slightly when
	       ;; we put up a dialog box?
	       (:change-background-for-dbox-emphasis nil)

	       ;; should we use extra large fonts and line styles?
	       (:large T)

	       ;;==================================================
	       ;; Colors -- changing these has no effect on a
	       ;;           monochrome display

	       ;; black
	       (:black (create-schema nil
				      (:red 0.0)
				      (:green 0.0)
				      (:blue 0.0)))

	       ;; really dark gray
	       (:really-dark-gray
		(create-schema nil
			       (:red 0.4)
			       (:green 0.4)
			       (:blue 0.4)))

	       ;; dark gray
	       (:dark-gray (create-schema nil
					  (:red 0.5)
					  (:green 0.5)
					  (:blue 0.5)))

	       ;; medium gray
	       (:medium-gray (create-schema nil
					    (:red 0.7)
					    (:green 0.7)
					    (:blue 0.7)))

	       ;; light gray
	       ;; (use 0.89 instead of 0.9 to make xwd/xpr do the
	       ;; right thing)
	       (:light-gray (create-schema nil
					   (:red 0.89)
					   (:green 0.89)
					   (:blue 0.89)))

	       ;; really light gray
	       (:really-light-gray (create-schema nil
						  (:red 0.95)
						  (:green 0.95)
						  (:blue 0.95)))

	       ;; white
	       (:white (create-schema nil
				      (:red 1.0)
				      (:green 1.0)
				      (:blue 1.0)))
	       ;;==================================================

	       ;; ========== halftones ==========
	       (:white-halftone-image (opal::halftone-image 0))
	       (:light-gray-halftone-image (opal::halftone-image 25))
	       (:gray-halftone-image (opal::halftone-image 50))
	       (:dark-gray-halftone-image (opal::halftone-image 75))
	       (:black-halftone-image (opal:halftone-image 100))

	       ;; bitmap for opal:black-fill
	       (:black-fill-bitmap
		(create-instance nil opal:bitmap
				 (:image (opal:halftone-image 100))))
	       )
(call-schema *options* :use-default-values)

;;;============================================================
;;; *colors* -- determines the color of various parts of the editor.
;;;============================================================

(defun make-filling-style (red green blue)
  (create-instance
   nil opal:filling-style
   (:foreground-color
    (create-instance nil opal:color (:red red) (:green green) (:blue blue)))))

(create-schema '*colors*
	       ;; actual colors to use
	       (:black
		(o-formula (if (gvl :color-display)
			       (gvl :black-color)
			     (gvl :black-monochrome))))
	       (:dark-gray
		(o-formula (if (gvl :color-display)
			       (gvl :dark-gray-color)
			     (gvl :dark-gray-monochrome))))
	       (:medium-gray
		(o-formula (if (gvl :color-display)
			       (gvl :medium-gray-color)
			     (gvl :medium-gray-monochrome))))
	       (:light-gray
		(o-formula (if (gvl :color-display)
			       (gvl :light-gray-color)
			     (gvl :light-gray-monochrome))))
	       (:light-gray-for-dbox-emphasis
		(o-formula (if (and (gvl :color-display)
				    (gv *options*
					:change-background-for-dbox-emphasis))
			       (gvl :really-light-gray-color)
			     (gvl :white))))
	       (:white
		(o-formula (if (gvl :color-display)
			       (gvl :white-color)
			     (gvl :white-monochrome))))

	       ;; is this a 'color' display?
	       (:color-display nil)

	       ;; colors for a monochrome display
	       (:black-monochrome opal:black-fill)
	       (:dark-gray-monochrome opal:dark-gray-fill)
	       (:medium-gray-monochrome opal:gray-fill)
	       (:light-gray-monochrome opal:light-gray-fill)
	       (:really-light-gray-monochrome opal:white-fill)
	       (:white-monochrome opal:white-fill)

	       ;; colors for a 'color' display -- may not be true
	       ;; color (3max with monochrome monitor)
	       (:black-color
		(o-formula (make-filling-style (gv *options* :black :red)
					       (gv *options* :black :green)
					       (gv *options* :black :blue))))
	       (:dark-gray-color
		(o-formula
		 (make-filling-style (gv *options* :dark-gray :red)
				     (gv *options* :dark-gray :green)
				     (gv *options* :dark-gray :blue))))
	       (:medium-gray-color
		(o-formula
		 (make-filling-style (gv *options* :medium-gray :red)
				     (gv *options* :medium-gray :green)
				     (gv *options* :medium-gray :blue))))
	       (:light-gray-color
		(o-formula
		 (make-filling-style (gv *options* :light-gray :red)
				     (gv *options* :light-gray :green)
				     (gv *options* :light-gray :blue))))
	       (:really-light-gray-color
		(o-formula
		 (make-filling-style (gv *options* :really-light-gray :red)
				     (gv *options* :really-light-gray :green)
				     (gv *options* :really-light-gray :blue))))
	       (:white-color
		(o-formula (make-filling-style (gv *options* :white :red)
					       (gv *options* :white :green)
					       (gv *options* :white :blue))))
	       )

;;;============================================================
;;; *fonts-and-styles* -- fonts and line styles
;;;============================================================
(create-schema '*fonts-and-styles*
	       ;; ========== actual fonts ==========
	       ;; font for labels (on objects)
	       (:label-font (o-formula (if (gv *options* :large)
					   (gvl :big-label-font)
					 (gvl :normal-label-font))))

	       ;; fixed width label font
	       (:fixed-label-font
		(o-formula (if (gv *options* :large)
			       (gvl :big-fixed-label-font)
			     (gvl :normal-fixed-label-font))))

	       ;; font for button labels
	       (:button-label-font
		(o-formula (if (gv *options* :large)
			       (gvl :big-button-label-font)
			     (gvl :normal-button-label-font))))

	       ;; fixed width button label font
	       (:fixed-button-label-font
		(o-formula (if (gv *options* :large)
			       (gvl :big-fixed-button-label-font)
			     (gvl :normal-fixed-button-label-font))))

	       ;; fonts for arrow asterisk
	       (:thin-arrow-asterisk-font
		(o-formula (if (gv *options* :large)
			       (gvl :big-thin-arrow-asterisk-font)
			     (gvl :normal-thin-arrow-asterisk-font))))
	       (:thick-arrow-asterisk-font
		(o-formula (if (gv *options* :large)
			       (gvl :big-thick-arrow-asterisk-font)
			     (gvl :normal-thick-arrow-asterisk-font))))

	       ;; fonts for box asterisk
	       (:thin-box-asterisk-font
		(o-formula (if (gv *options* :large)
			       (gvl :big-thin-box-asterisk-font)
			     (gvl :normal-thin-box-asterisk-font))))
	       (:thick-box-asterisk-font
		(o-formula (if (gv *options* :large)
			       (gvl :big-thick-box-asterisk-font)
			     (gvl :normal-thick-box-asterisk-font))))

	       ;; popup menu fonts
	       (:popup-title-font
		(o-formula (if (gv *options* :large)
			       (gvl :big-popup-title-font)
			     (gvl :normal-popup-title-font))))
	       (:popup-item-font
		(o-formula (if (gv *options* :large)
			       (gvl :big-popup-item-font)
			     (gvl :normal-popup-item-font))))
	       (:popup-inactive-font
		(o-formula (if (gv *options* :large)
			       (gvl :big-popup-inactive-font)
			     (gvl :normal-popup-inactive-font))))

	       ;; a tiny font
	       (:microscopic-font
		(o-formula (if (gv *options* :large)
			       (gvl :big-microscopic-font)
			     (gvl :normal-microscopic-font))))
	       
	       ;; ========== actual line styles ==========
	       ;; line for feedback when creating, moving or resizing
	       ;; objects
	       (:feedback-dash
		(o-formula (if (gv *options* :large)
			       (gvl :big-feedback-dash)
			     (gvl :normal-feedback-dash))))

	       ;; line for showing when an object is selected -- 
	       ;; dotted line doesn't have enough distance between dots
	       (:selected-dash
		(o-formula (if (gv *options* :large)
			       (gvl :big-selected-dash)
			     (gvl :normal-selected-dash))))

	       ;; line styles for miro boxes and arrows
	       (:thin-solid
		(o-formula (if (gv *options* :large)
			       (gvl :big-thin-solid)
			     (gvl :normal-thin-solid))))
	       (:thin-dash
		(o-formula (if (gv *options* :large)
			       (gvl :big-thin-dash)
			     (gvl :normal-thin-dash))))
	       (:thick-solid
		(o-formula (if (gv *options* :large)
			       (gvl :big-thick-solid)
			     (gvl :normal-thick-solid))))
	       (:thick-dash
		(o-formula (if (gv *options* :large)
			       (gvl :big-thick-dash)
			     (gvl :normal-thick-dash))))
	       ;;; line style for dialogbox frames
	       (:db-frame-width
		(o-formula (if (gv *options* :large)
			       (gvl :big-db-frame-width)
			     (gvl :normal-db-frame-width))))
	       (:db-real-frame-width
		(o-formula (if (gv *options* :large)
			       (gvl :big-db-real-frame-width)
			     (gvl :normal-db-real-frame-width))))
	       (:db-frame-style
		(o-formula (if (gv *options* :large)
			       (gvl :big-db-frame-style)
			     (gvl :normal-db-frame-style))))

	       ;; ========== normal line styles ==========
	       (:normal-feedback-dash
		(create-instance nil opal:dashed-line))

	       (:normal-selected-dash
		(create-instance nil opal:line-style
				 (:line-style :dash)
				 (:dash-pattern '(2 4))
				 (:line-thickness 3)))

	       (:normal-thin-solid (create-instance nil opal:line-1))
	       (:normal-thin-dash dash-ls)
	       (:normal-thick-solid
		(create-instance nil opal:line-style
				 (:line-thickness 3)))
	       (:normal-thick-dash
		(create-instance nil dash-ls
				 (:line-thickness 3)))

	       (:normal-db-frame-width 10)
	       (:normal-db-real-frame-width 6)
	       (:normal-db-frame-style
		(create-instance nil opal:line-style
				 (:line-thickness 6)
				 (:stipple grey-bitmap)
				 (:tile grey-bitmap)))

	       ;; ========== big line styles ==========
	       (:big-feedback-dash
		(create-instance nil opal:line-style
				 (:line-style :dash)
				 (:dash-pattern '(4 4))
				 (:line-thickness 2)))

	       (:big-selected-dash
		(create-instance nil opal:line-style
				 (:line-style :dash)
				 (:dash-pattern '(2 4))
				 (:line-thickness 6)))
	       
	       (:big-thin-solid
		(create-instance nil opal:line-2))
	       (:big-thin-dash
		(create-instance nil dash-ls
				 (:line-thickness 2)))
	       (:big-thick-solid
		(create-instance nil opal:line-style
				 (:line-thickness 6)))
	       (:big-thick-dash
		(create-instance nil dash-ls
				 (:line-thickness 6)))

	       (:big-db-frame-width 20)
	       (:big-db-real-frame-width 12)
	       (:big-db-frame-style
		(create-instance nil opal:line-style
				 (:line-thickness 12)
				 (:stipple grey-bitmap)
				 (:tile grey-bitmap)))

	       ;; ========== normal fonts ==========
	       (:normal-label-font
		(create-instance nil opal:font
				 (:size :medium)
				 (:family :sans-serif)))

	       (:normal-button-label-font
		(create-instance nil opal:font
				 (:size :small)
				 (:face :bold)
				 (:family :sans-serif)))

	       (:normal-fixed-label-font
		(create-instance nil opal:font
				 (:size :medium)
				 (:family :fixed)))

	       (:normal-fixed-button-label-font
		(create-instance nil opal:font
				 (:size :small)
				 (:face :bold)
				 (:family :fixed)))

	       (:normal-thin-arrow-asterisk-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:size :very-large)
				 (:face :roman)))

	       (:normal-thick-arrow-asterisk-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:size :very-large)
				 (:face :bold)))

	       (:normal-thin-box-asterisk-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:size :very-large)
				 (:face :roman)))

	       (:normal-thick-box-asterisk-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:size :very-large)
				 (:face :bold)))

	       (:normal-popup-title-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:size :medium)
				 (:face :roman)))

	       (:normal-popup-item-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:face :bold)
				 (:size :medium)))

	       (:normal-popup-inactive-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:face :italic)
				 (:size :medium)))

	       (:normal-microscopic-font
		(create-instance nil opal:font-from-file
				 (:font-name "nil2")))

	       ;; ========== big fonts ==========
	       (:big-label-font
		(create-instance nil opal:font
				 (:size :large)
				 (:family :sans-serif)))

	       (:big-button-label-font
		(create-instance nil opal:font
				 (:size :medium)
				 (:face :bold)
				 (:family :sans-serif)))

	       (:big-fixed-label-font
		(create-instance nil opal:font
				 (:size :large)
				 (:family :fixed)))

	       (:big-fixed-button-label-font
		(create-instance nil opal:font
				 (:size :medium)
				 (:face :bold)
				 (:family :fixed)))

	       (:big-thin-arrow-asterisk-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:size :very-large)
				 (:face :roman)))

	       (:big-thick-arrow-asterisk-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:size :very-large)
				 (:face :bold)))

	       (:big-thin-box-asterisk-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:size :very-large)
				 (:face :roman)))

	       (:big-thick-box-asterisk-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:size :very-large)
				 (:face :bold)))

	       (:big-popup-title-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:size :large)
				 (:face :roman)))

	       (:big-popup-item-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:face :bold)
				 (:size :large)))

	       (:big-popup-inactive-font
		(create-instance nil opal:font
				 (:family :serif)
				 (:face :italic)
				 (:size :large)))

	       ;; really don't want to make this one bigger since its
	       ;; purpose in life is to be as small as possible
	       (:big-microscopic-font
		(o-formula (gvl :normal-microscopic-font)))
	       )
