;; Miro editor load file. 
;;
;; this file loads Garnet and the Miro editor. 
;
;/*****************************************************************************
;                Copyright Carnegie Mellon University 1992
;
;                      All Rights Reserved
;
; Permission to use, copy, modify, and distribute this software and its
; documentation for any purpose and without fee is hereby granted,
; provided that the above copyright notice appear in all copies and that
; both that copyright notice and this permission notice appear in
; supporting documentation, and that the name of CMU not be
; used in advertising or publicity pertaining to distribution of the
; software without specific, written prior permission.
;
; CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
; ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
; CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
; ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
; WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
; ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
; SOFTWARE.
;*****************************************************************************/
;

;; compile as needed
(defvar Miro-Compile T)
#+cmu (setq compiler::*verbose* nil)

;; setq this to a filename to get a saved garnet
(defvar Miro-Disksave-After-Garnet nil)

;; setq this to a filename to get a saved editor
(defvar Miro-Disksave-Editor nil)

(defvar Miro-Garnet-Gadget-Files)

;; comment this out if windows start to "walk"
(setq *twm-bug* nil)

;; Make sure we load the correct version of garnet for the lisp we are using.
;; Right now, assume that we are using either CMU or Allegro Common Lisp.

;; CONFIG: set garnet-loader, load-clx-p, Garnet-Version appropriately for
;;         your system.
(defvar garnet-loader "/afs/cs/project/garnet/garnet-loader.lisp")
#-cmu (progn
       (setq load-clx-p T)
       (setq launch-process-p T)
       (setq *global-gc-behavior* :auto)
       (setf (sys:gsgc-switch :print) T)
       )
#+sun (progn
	(setq Garnet-Version :external) ; don't use :cmu-allegro for now
	(setq garnet-loader "/usr/garnet/garnet-loader.lisp")
	)
#+mips (progn
	 (setq load-clx-p T)
	 (setq Garnet-Version :pmax-allegro)
	 )

;; make sure we know where the files are coming from
(defvar Miro-LoadVerbose T)
(setf *load-verbose* Miro-LoadVerbose)

;; set miro path name and search list
(defvar Miro-SourceDir "/usr/miro/src/bin/editor/")
(defvar Miro-ObjectDir "/usr/miro/obj/bin/editor/")
(defvar Miro-PathName (list Miro-ObjectDir Miro-SourceDir))

;; a list of "local" miro directories.  This list will probably look something
;; like this: ("top-level-editor-directory/" "top-level-editor-directory/src/")
(defvar Miro-LocalPathNames nil)

#+cmu
(unless (ext:search-list "miro:") 
	(setf (ext:search-list "miro:") 
	      (append Miro-LocalPathNames Miro-PathName)))

(load garnet-loader)

(kr:s-value inter:running-priority-level :stop-when nil)
(kr:s-value inter:normal-priority-level :stop-when :if-any)

;; load extra garnet stuff I need
(defun load-gadget (file)
  (load (merge-pathnames file
			 #+cmu "gadgets:"
			 #-cmu Garnet-Gadgets-PathName)))
(setq Miro-Garnet-Gadget-Files
      (list "radio-buttons-loader" "text-buttons-loader"
	    "labeled-box-loader" "h-scroll-loader" "v-scroll-loader"
	    "h-slider-loader" "v-slider-loader"
	    "trill-device-loader" "scrolling-menu-loader"
	    "browser-gadget-loader" "scrolling-labeled-box-loader"
	    "scrolling-window-loader" "menu-loader"
	    ))
(dolist (file Miro-Garnet-Gadget-Files)	(load-gadget file))

;;(use-package 'miro)
(in-package 'miro)
(use-package 'garnet-debug)

;; CONFIG: the ipql directory
(defvar *ipql-dir* "/usr/miro/lib/ipql")

;; CONFIG: Miro-Lpr should be the *full* path to your postscript printing tool.
;;         Miro-Lpr-Args should be a list of arguments, if any, required by
;;         your printing tool.  The output file will immediately follow the
;;         final argument in Miro-Lpr-Args.  Miro-Lpr-Printer-Arg should
;;         be the argument that your printer tool expects to tell it which
;;         printer to use.  The name of the printer will come immediately
;;         after Miro-Lpr-Printer-Arg; if there should be a space between
;;         the argument and the printer name, that should be reflected here.
(defvar Miro-Lpr "/usr/cs/bin/lpr")
(defvar Miro-Lpr-Args nil)
(defvar Miro-Lpr-Printer-Arg "-P")

;; temporary definitions to keep lisp happy
(defun run-editor ()
  (format T "~%miro::run-editor: WE SHOULDN'T BE HERE!!!~%")
  (force-output))
(defun disksave ()
  (format T "~%miro::disksave: WE SHOULDN'T BE HERE!!!~%")
  (force-output))

(defvar Miro-Local-PathNames)
(defvar Miro-PathName)
(defvar Miro-AmbigPath)
(defvar Miro-Files)

(setq Miro-LocalPathNames user::Miro-LocalPathNames)
(setq Miro-PathName user::Miro-PathName)

(defun find-on-path (file &key (lispfile T))
  (mapc
   #'(lambda (dir)
       (let* ((filename (merge-pathnames file dir))
	      (faslname (make-pathname :type "fasl"
				       :defaults filename))
	      (lispname (make-pathname :type "lisp"
				       :defaults filename))
	      )
	 (when (probe-file filename)
	       (return-from find-on-path filename))
	 (when lispfile
	       (when (probe-file faslname)
		     (return-from find-on-path faslname))
	       (when (probe-file lispname)
		     (return-from find-on-path lispname)))
	 ))
   (append Miro-LocalPathNames Miro-PathName))
  nil)

;; add search path for ambiguity checker
(setq Miro-AmbigPath "/usr/miro/bin/")
#+cmu
(setf (ext:search-list "ambig:") (list Miro-AmbigPath))

;; load miro files
(defvar *loaded-miro-files* nil)
(defun load-miro-files (&optional dont-run-editor)
  (when (stringp user::Miro-Disksave-After-Garnet)
	(format T "~%Reconnecting Garnet...~%")
	(force-output)
	(opal:reconnect-garnet)
	)
  (format t "Loading Editor files....~%")
  (force-output)
  (setq Miro-Files
	(list "miro-defs" "miro-toolkit" "miro-styles" "miro-scrollpad"
	      "nested-popup-menu" "miro-main" "miro-objects" "miro-menus"
	      "miro-cmnds" "miro-parse" "miro-inters"))
  (dolist (file Miro-Files)
	  (when user::Miro-Compile
		(let* ((lisp-file
			(or (find-on-path (format nil "~A.lisp" file)
					  :lispfile nil)
			    (make-pathname :directory user::Miro-SourceDir
					   :name file :type "lisp")))
		       (lisp-write-date (file-write-date lisp-file))
		       (fasl-file
			(or (find-on-path (format nil "~A.fasl" file)
					  :lispfile nil)
			    (make-pathname :directory user::Miro-ObjectDir
					   :name file :type "fasl")))
		       (fasl-write-date (file-write-date fasl-file))
		       )
		  (unless (and fasl-write-date
			       (< lisp-write-date fasl-write-date))
			  (format T "[ Compiling ~S into ~S... ]~%"
				  lisp-file fasl-file)
			  (force-output)
			  (compile-file lisp-file :output-file
					fasl-file :verbose T :print T)
			  )
		  ))
	  (load (find-on-path file))
	  )

  (format t "...Miro Editor loaded.~%")
  (force-output)

  (setq *loaded-miro-files* T)

  (unless dont-run-editor
	  (format T "Running the Editor...~%")
	  (force-output)
	  (miro::run-editor)
	  )
  )


(defun garnet-disksave ()
  (when (stringp user::Miro-Disksave-After-Garnet)
	(format T "~%Saving Garnet in file ~A...~%" user::Miro-Disksave-After-Garnet)
	(format T "~%disksave: garbage collecting...~%")
	(force-output)
	#+cmu (extensions:gc)
	#-cmu (excl:gc)
	(format T "~%disksave: disconnecting garnet...~%")
	(force-output)
	(opal:disconnect-garnet)
	(format T "~%disksave: saving this lisp...~%")
	(force-output)
	#+cmu (extensions:save-lisp
	       user::Miro-Disksave-After-Garnet
	       :init-function 'load-miro-files
	       :print-herald T)
	#-cmu (excl:dumplisp
	       :name user::Miro-Disksave-After-Garnet
	       :restart-function 'load-miro-files
	       :read-init-file nil)
	(format T "~%disksave: done~%")
	(force-output)
	(unless *loaded-miro-files*
		#+cmu (extensions:quit)
		#-cmu (excl:exit)
		)
	))

(defun load-miro ()
  (if (stringp user::Miro-Disksave-After-Garnet)
      (garnet-disksave)
    (if (stringp user::Miro-Disksave-Editor)
	(progn (load-miro-files T)
	       (format T "~%running the editor...~%")
	       (force-output)
	       (miro::run-editor T)
	       (format T "~%saving the editor in ~S...~%"
		       user::Miro-Disksave-Editor)
	       (force-output)
	       (miro::disksave user::Miro-Disksave-Editor)
	       (unless miro::*started-from-disksave*
		       #+cmu (extensions:quit)
		       #-cmu (excl:exit)
		       )
	       (loop (sleep 1000000))
	       )
      (load-miro-files)))
  )

(load-miro)
