/* VAR.H

   Type definitions for variables in box predicates.

   $Header: var.h,v 1.2 91/11/13 03:09:19 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef VAR_H
#define VAR_H

#include <my-types.h>

/* Intrvl in Var type */
#include "interval.h"

/* This header file also refers (indirectly) to "struct elt_list" of the
   objs.h header file in the Var type.
*/

#define NOT_BOUND (-1)

/* TYPE DEFINITIONS ======================================================== */

typedef enum {
    /* note: both IdVal's and StringVal's -> StringVarKind's */
    IntVarType, StringVarType, BoolVarType, BoxTypeVarType
} VarType;

/* See the notes in II:24 for a description of the idea behind variable
   "counts" and the way they are used to rank a variable in rank.c.
*/

typedef struct var_cnt {
    int eq_cnt;			/* number of attr's in 'both' lists */
    int low_cnt;		/* number of attr's in 'low' list */
    int high_cnt;		/* number of attr's in 'high' list */
} VarCnt;

typedef struct var {
    String name;		/* variable name (in table) */
    VarType type;		/* type of this variable */
    int first;			/* order of first box (NOT_BOUND if none) */
    VarCnt *cnt;		/* counts for this variable */
    struct elt_list *boxes;	/* boxes containing occurence of this var */
} Var;

typedef struct var_list {
    struct var_list *next;
    Var *var;
} VarList;

#endif VAR_H
