/* TOP.H

   Macro definitions for the top-level cpc(1) module top.c.

   $Header: top.h,v 1.2 91/10/21 18:47:58 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef TOP_H
#define TOP_H

/* Command-line syntax:

   cpc [-a] [-h hint-file] [-t type-file] [-o out-file] iff-file

     -a            assume semantic relations between atomic boxes only
     -h hint-file  name of file containing hint info (default below)
     -t type-file  name of file containing box-type info (default below)
     -o out-file   name of output file (default stdout)
     iff-file      constraint picture to read (default stdin)

   Note: if 'type-file' is relative, and cannot be found in the current
   directory, then the TYPE_FILE_DIR directory given below is also searched.
   Similarly for the 'hint-file' and the HINT_FILE_DIR.
*/

#define SYNTAX_STRING\
  "SYNTAX: %s [-a] [-h hint-file] [-t type-file] [-o out-file] [iff-file]\n"

/* Default directory and filename for 'type-file' */
#define TYPE_FILE_DIR  "/usr/miro/libi/iff/"
#define TYPE_FILE_NAME "unix-types.iff"

/* Default directory and filename for 'hint-file' */
#define HINT_FILE_DIR TYPE_FILE_DIR
#define HINT_FILE_NAME "unix-hints.txt"

#endif TOP_H
