%{
/* $Header: pred.l,v 1.2 91/10/21 01:36:05 heydon Exp $

   Lex source file for parsing box predicates contained in boxes in
   constraint pictures. This parsing file works in conjunction with the
   yacc file "pred.y".
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#include <my-types.h>
#include "mem.h"
#include <my-defs.h>

#include "parse-pred.h"
#include "parse-pred.g"
#include "pred.y.h"

#define YYLVAL_UNION
#include <yacc-globals.h>

/* Redefine the input() macro to read future characters from the global String
   yyin_string (declared in parse.g) instead of from the global FILE *yyin.
*/

#undef input
#define input()\
  (((yytchar = (yysptr > yysbuf ? U(*--yysptr) : *yyin_string++)) == 10 \
    ? (yylineno++,yytchar) : yytchar) == '\0' \
    ? 0 : yytchar)
%}
WHITECHAR	[ \t\n]
SINGLECHAR	[(){},$!]
ID_REGEXP	[a-zA-Z][-_?a-zA-Z0-9]*
STRING_REGEXP	\"([^"]*)\"
INTEGER_REGEXP	-?[0-9]+
UNKNOWN		[^ \t\n(){},$!][^ \t\n]*
%%
{WHITECHAR}+		;
"&&"			{ yylval.pred_op = Conjunction; return(PRED_OP); }
"="			{ yylval.rel = Eq; return(RELATION); }
"<"			{ yylval.rel = Less; return(RELATION); }
"<="			{ yylval.rel = LessEq; return(RELATION); }
">"			{ yylval.rel = Greater; return(RELATION); }
">="			{ yylval.rel = GreaterEq; return(RELATION); }
{SINGLECHAR}		{ return(yytext[0]); }
{ID_REGEXP}		{ CopyString(yylval.string_val,yytext);
			  return(IDENTIFIER);
			}
{STRING_REGEXP}		{ yytext[yyleng-1] = '\0';
			  CopyString(yylval.string_val,yytext+1);
			  return(STRING);
			}
{INTEGER_REGEXP}	{ yylval.int_val = atoi(yytext);
			  return(INTEGER);
			}
{UNKNOWN}		{ return(UNKNOWN_TOKEN); }
%%
