/* HINTS.H

   Type definitions and function declarations for the hints.c module, which
   provides facilities for reading and storing cpc(1) hint files.

   $Header: hints.h,v 1.3 91/09/24 22:16:50 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef HINTS_H
#define HINTS_H

#include <my-types.h>

/* PrimValueType in HdsHint type */
#include "parse-pred.h"

/* MACRO DEFINITIONS ======================================================= */

/* number of different kinds of constraint arrows (syn, sem, con, con*) */
#define NUM_ARROW_KINDS 4

/* number of "degrees of freedom" of a constraint arrow -- namely, the number
   of different ways it can be anchored (at 0, Tail, Head, or 2 ends) */
#define NUM_ARROW_DEGREES 4

/* number of arrow parity values, Pos and Neg */
#define NUM_PARITY 2

/* TYPE DEFINITIONS ======================================================== */

typedef float *ArrowRanks[NUM_ARROW_KINDS][NUM_ARROW_DEGREES][NUM_PARITY];

typedef enum {
    BstHds=0, XhtHds=1, HtHds=2
} HdsKind;

typedef struct hds_hint {
    String name;		/* corresponding attribute name (in table) */
    PrimValueType type;		/* type of corresponding slot values */
    HdsKind kind;		/* kind of hds */
    String arg;			/* argument to pass for creation */
    String bst_arg;		/* argument to pass if upgraded to BST-HDS */
} HdsHint;

typedef struct hds_hint_list {
    struct hds_hint_list *next;
    HdsHint *hds_hint;
} HdsHintList;

/* FUNCTION DECLARATIONS =================================================== */

Boolean ProcessHintFile( /* FILE *fp, String name, Pict *pict */ );
/* Process the hint file 'fp' named 'name', placing the information contained
   in that hint file into the 'pict' structure, as appropriate. In particular,
   each line of the hint file starts with some keyword that determines how
   that line is processed. The data on each such line is placed in 'pict' as
   follows:

   PERMS perm_1 perm_2 ... perm_n
     Sets up internal data structures for future syn, sem, con, and con*
     lines.

   ARROW syn  i val_1 val_2 ... val_n
   ARROW sem  i val_1 val_2 ... val_n
   ARROW con  i val_1 val_2 ... val_n
   ARROW con* i val_1 val_2 ... val_n
     Sets values in the 'ranks' field of 'pict', where 0 <= i <= 2 represents
     the number of ends of each kind of arrow that are anchored. Each 'val_i'
     is a probability in the range [0,1].

   BOXTYPE name val
     Sets the 'sum_rank' field of the BoxType named 'name' to 'val', which is
     a probability in the range [0,1]. This value represents the probability
     that a random box having a type in the subtree of this type's parent is
     actually in the subtree of this type.

   ATTR name low high num-expected  (* for Int's, String's, Id's *)
   ATTR name false-prob true-prob   (* for Bool's *)
     Determine a uniform probability distribution for the box attribute named
     'name'. The information is stored in the 'min', 'max', and 'range_size'
     field of each attribute. Only Int, String, Id, and Bool attribute types
     are processed (not BoxType's or lists of any kind).

   HDS element attr-name hds-type ["arg-string"] ["bst-arg-string"]
     Declare for each 'element' (which should be "box", "syn", "subj", "obj",
     or "con") the the attribute 'attr-name' should use an HDS of type
     'hds-type' (which should be one of "bst", "ht", or "xht"). The
     "arg-string" enclosed in double quotes is a string used in the creation
     of the HDS. In the case where 'hds-type' is "ht" or "xht", the compiler
     may "promote" this attribute to use a BST-HDS; in this case, the string
     "bst-arg-string" is used as the argument string in the creation of the
     BST-HDS. Both 'arg-string' and 'bst-arg-string' default to the empty
     string.

   Returns True iff errors occur processing the hint file.
*/

#endif HINTS_H
