/* HDS.H

   Type definitions and function declarations for the hds.c module, which
   provides facilities for constructing representations of the IPQL's HDS
   structures.

   $Header: hds.h,v 1.4 91/09/04 22:06:57 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef HDS_H
#define HDS_H

#include <my-types.h>

/* HdsKind in Hds type */
#include "hints.h"

/* Val in Slot type */
#include "interval.h"

/* MACRO DEFINITIONS ======================================================= */

/* ":OTHERS" value */
#define Others (Val *)0x08

/* box attribute names */
#define SIDE_ATTR    "side"
#define TYPE_ATTR    "type"
#define SYSNAME_ATTR "sysname"

/* arrow attribute names */
#define DIRECT_ATTR  "direct"
#define PARITY_ATTR  "parity"
#define PERM_ATTR    "perm"
#define FROM_ATTR    "from"
#define TO_ATTR      "to"

/* variable name modifiers */
#define TAIL "tail"
#define HEAD "head"
#define NAME "name"

/* key names */
#define OTHERS_KEY   ":OTHERS"
#define NEW_SLOT_KEY ":NEW-SLOT"
#define ALL_KEY      ":ALL"
#define SUBJ_KEY     ":SUBJ"
#define OBJ_KEY      ":OBJ"
#define TRUE_KEY     "T"
#define FALSE_KEY    "NIL"

/* TYPE DEFINITIONS ======================================================== */

typedef struct slot {
    struct slot *next;		/* next slot in list of slots */
    IntrvlKind kind;		/* kind of key value */
    Val *key;			/* key value */
    struct hds *hds;		/* HDS hanging off this slot */
    Boolean new_slot;		/* True iff this is a "new-slot" OTHERS slot */
} Slot;

typedef struct hds {
    HdsHint *hint;		/* associated hint for Attr and creation arg */
    HdsKind kind;		/* kind of HDS (may have been "promoted") */
    Slot *slots;		/* list of filled slots */
} Hds;

/* DEBUGGING FUNCTION DECLARATIONS ========================================= */

#ifdef DEBUG
#endif DEBUG

/* FUNCTION DECLARATIONS =================================================== */

void ConstructHdsStructures( /* INOUT Pict *pict */ );
/* Constructs the required Hds structures in 'pict->hds[]' for the constraint
   picture embodied by 'pict'.
*/

void GenerateHdsConstructors( /* FILE *fp, Pict *pict*/ );
/* Writes the IPQL commands that construct the Hds structures in 'pict->hds[]'
   to the output FILE 'fp'.
*/

void GenerateQuery( /* FILE *fp, Pict *pict */ );
/* Writes the IPQL commands comprising the query corresponding to the
   constraint embodied by 'pict' to the output FILE 'fp'.
*/

#endif HDS_H
