/* COMPILE.H

   Type definitions and function declarations for the compile.c module, which
   compiles a Pict representation of a constraint picture.

   $Header: compile.h,v 1.1 91/08/25 16:36:01 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef COMPILE_H
#define COMPILE_H

#include <my-types.h>

/* TYPE DEFINITIONS ======================================================== */

/* FUNCTION DECLARATIONS =================================================== */

Boolean CompilePict( /* FILE *fp, Pict *pict */ );
/* Compile the constraint picture represented by 'pict', sending the output
   code to the FILE 'fp'. If 'pict' fails any of the well-formedness tests on
   constraint pictures (i.e., there is a cycle among containment relations or
   some box pattern is both a "left" *and* a "right" box), an error message is
   sent to stderr, and no code is generated.

   Returns True iff 'pict' is an ill-formed constraint picture.
*/

#endif COMPILE_H
