/* ATTR.H

   Type definitions for attribute values and attribute lists.

   $Header: attr.h,v 1.2 91/10/28 18:41:32 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef ATTR_H
#define ATTR_H

#include <my-types.h>

/* ValueType in Attr type */
#include "parse-pred.h"

/* TYPE DEFINITIONS ======================================================== */

typedef union attr_val {
    int i_val;			/* for Int attributes */
    String s_val;		/* for String, Id attributes */
    float f_val;		/* for Boolean attrs (min=False, max=True) */
} AttrVal;

typedef struct attr {
    String name;		/* name of attribute (in table) */
    String boxtype_name;	/* name of BoxType that introduced this attr */
    ValueType type;		/* type of associated values */
    Boolean required;		/* True iff this attr is mandatory */
    AttrVal min,max;		/* min and max values for ranking */
    float dist;			/* "distance" between min & max */
    int range_size;		/* num expected values in [min,max] */
} Attr;

typedef struct attr_list {
    struct attr_list *next;
    Attr *attr;			/* attribute value */
} AttrList;

#endif ATTR_H
