/* PICT.H

   Type definitions and function declarations for the pict.c module, which
   provides facilities for manipulating an instance picture.

   $Header: pict.h,v 1.2 91/08/25 23:42:02 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef PICT_H
#define PICT_H

#include <my-types.h>

#include "box-type.h"
#include "id-table.h"
#include "elts.h"
#include "sysname.h"

/* MACRO DEFINITIONS ======================================================= */

/* lower Range limit */
#define NONE (0)

/* unbounded upper Range limit */
#define INFINITY (-2)

/* indices for arrays in Pict structure below */
#define SIDES 2

/* TYPE DEFINITIONS ======================================================== */

typedef struct pict_side {
    int cnt;			/* number of boxes on this side */
    int levels;			/* number of levels on this side */
    union {
	Box *boxes;		/* linked list of boxes */
	Box **level;		/* array of boxes by level */
    } u;
} PictSide;

typedef struct pict {
    PictSide s[SIDES];
    PermSet perms;		/* strict upper-bound on permission set*/
    int perm_cnt;		/* number of different permissions */
    PermList *perm_list;	/* list of permissions */
    TableEntry **perm_entries;	/* array of permissions (in table) */
    BoxTypeList *box_types;	/* list of box types read from types file */
    IdHashTable table;		/* hash table of type, attr, perm names */
    BSysnameTable b_sysnames;	/* hash table of box sysnames */
    ASysnameTable a_sysnames;	/* hash table of arrow sysnames */
} Pict;

/* FUNCTION DECLARATIONS =================================================== */

Pict *NewPict( /* void */ );
/* Return a pointer to a new, initialized Pict object.
*/

void BuildPermissionArray( /* Pict *pict */ );
/* Builds a permission array in 'pict->perm_names' by allocating space for the
   array, and then making each entry 'pict->perm_names[i]' point to the name
   of the permission in the IdHashTable 'pict->table' whose associated index
   is 'i'.

   PRE-CONDITION: This routine assumes that each permission has a unique
   assigned index in the range [0,pict->perm_cnt), that each has been
   installed in the IdHashTable 'pict->table', and that 'pict->perm_list'
   contains a linked list of all permission names.
*/

#endif PICT_H
