/* EXTRACT-ELTS.H

   Declarations for functions extracting info from parse tree by calling
   routines in the extract library.

   $Header: extract-elts.h,v 1.1 91/08/01 20:06:18 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef EXTRACT_ELTS_H
#define EXTRACT_ELTS_H

#include <my-types.h>

/* GLOBAL FUNCTION DECLARATIONS =========================================== */

void ConfigureHashTable( /* void */ );
/* Add entry names and property names to 'p' that should be recognized by this
   program during the parse. Any entry or property name not found in 'p'
   during the parse is ignored.
*/

Boolean Extract( /* Entry *p_tree, Pict *pict */ );
/* This routine processes the parse tree 'p_tree' and builds the resulting
   data structures in 'pict'. The routines it uses call the ParseError()
   family of error functions to process errors.

   RETURNS True iff errors were encountered decomposing the parse tree.
*/

#endif EXTRACT_ELTS_H
