/* BOX-TYPE.H

   Type definitions related to the BoxType type.

   $Header: box-type.h,v 1.1 91/08/01 20:03:42 heydon Exp $

   Written by Allan Heydon for the Miro project at Carnegie Mellon
*/

/*****************************************************************************
                Copyright Carnegie Mellon University 1992

                      All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of CMU not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 SOFTWARE.
*****************************************************************************/


#ifndef BOX_TYPE_H
#define BOX_TYPE_H

#include <my-types.h>

/* TYPE DEFINITIONS ======================================================== */

typedef enum {
    IntVal, IdVal, StringVal, BoolVal, BoxTypeVal
} PrimValueType;

typedef struct value_type {
    PrimValueType prim;		/* primitive, base type */
    int list_nesting;		/* number of "-list" suffixes */
} ValueType;

typedef struct attr {
    String name;		/* name of attribute */
    ValueType type;		/* type of associated values */
    Boolean required;		/* True iff this attr is mandatory */
} Attr;

typedef struct attr_list {
    struct attr_list *next;
    Attr *attr;			/* attribute value */
} AttrList;

typedef enum {
    SubjectRole=0, ObjectRole=1
} BoxRole;

typedef USint BoxTypeSet;

typedef struct box_type {
    String name;		    /* name of this type */
    String supertype;		    /* name of parent type */
    AttrList *attr_head;	    /* list of attrs assoc. w/ this type */
    int line_no;		    /* line # of TYPE entry for error msgs */
    struct box_type *parent;	    /* pointer to parent type of this type */
    struct box_type_list *children; /* children of this type */
    BoxRole role;		    /* "role" of box, Subj or Obj */
    BoxTypeSet box_type_val;	    /* power of 2 identifying this type */
    int num, top_range;		    /* values for O(1) ancestorship test */
} BoxType;

typedef struct box_type_list {
    struct box_type_list *next;
    BoxType *bt;
} BoxTypeList;

/* FUNCTION DECLARATIONS =================================================== */

BoxType *NewBoxType( /* int line_no */ );
/* Return a pointer to a new, initialized BoxType object. The 'line_no' field
   of the BoxType is initialized to 'line_no'.
*/

Boolean BuildTypeTree( /* INOUT Pict *pict */ );
/* For each of the types in pict->box_types, fill in the 'parent' field if the
   'supertype' field is non-NULL. This function requires that all of the types
   named in 'supertype' fields have been added to the TypeHashTable
   pict->table using the routine AddType() above.

   RETURNS True iff some error was found. An error occurs if a 'supertype'
   attribute names a non-existent type.
*/

#endif BOX_TYPE_H
