# nonatoms.awk
#
#/*****************************************************************************
#                Copyright Carnegie Mellon University 1992
#
#                      All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of CMU not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
# CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
# SOFTWARE.
#*****************************************************************************/
#
#
# Gawk(1) program to generate the sysnames of nonatomic boxes.
#
# $Header: nonatoms.awk,v 1.2 91/10/24 17:03:11 heydon Exp $
#
# Written by Allan Heydon for the Miro project at Carnegie Mellon
#
# SYNTAX
#   egrep '^[ \t]*>[ \t]*INSIDE' <IFFfile> | gawk -f nonatoms.awk -
#
# SYNOPSIS
#   Read INSIDE entries and output the sysname's of non-atomic boxes. Each
#   output line contains a single integer denoting the sysname of a box
#   guaranteed to contain at least one other box. The same number may appear
#   multiple times.
#
# BUGS
#   There are restrictions on the input iff file.
#
# FILES
#   ~miro/bin/iff2ipql		script using this awk program
#
# SEE ALSO
#   fs2iff(1), iff2ciff(1), iff2ipql(1), cpc(1)

# BEGIN =======================================================================

BEGIN {
  # set field separator so "=", ";" separate fields
  FS = "[ \t]*[;=][ \t]*"
}

# EVERY LINE ==================================================================

/INSIDE/ {
  match($1,"^[ \t]*>[ \t]*INSIDE[ \t]*");
  $1 = substr($1,RLENGTH+1);
  for (i=1; i < NF; i = i+2) {
    if ($i == "parent") { pindex = $(i+1); break; }
  }
  print pindex
}
