.\"
.\" Author:	Matt Bishop
.\" Address:	Research Institute for Advanced Computer Science
.\"		Mail Stop 230-5
.\"		NASA Ames Research Center
.\"		Moffett Field, CA  94035
.\" ARPA:	mab@riacs.arpa
.\" UUCP:	...!decvax!decwrl!riacs!mab
.\"		...!ihnp4!ames!riacs!mab
.\" Copyright:	(c) 1986 by Matt Bishop and the Research Institute for
.\"			Advanced Computer Science
.\"
.\" version
.ds Vr RIACS Audit Package version 3.1.3 Tue May 19 12:59:43 PDT 1992 (Matt.Bishop@dartmouth.edu)
.\"
.if n .ds Lq "
.if n .ds Rq "
.if t .ds Lq ``
.if t .ds Rq ''
.TH RINSTALL 8
.SH NAME
rinstall \- install the programs for the audit on a client
.SH SYNOPSIS
.BR rinstall " ["
.IR host " ["
.IR envfile " ["
.IR encrypt " ["
.IR secure " ] ] ] ]"
.SH DESCRIPTION
.LP
.I Rinstall
is a shell script that installs
.IR auditls (8),
.IR auditscan (1),
and any required encryption programs on a client;
the client can then be audited using
.IR audit (8)
or
.IR runaudit (8).
.PP
The first argument is the name of the client host;
it should be suitable for use with both
.IR %%REMCOPY%% (1)
and
.IR %%REMEXEC%% (1).
The second argument names the client's 
.I Environ
file,
which contains information about where the audit programs are to go
and how they are to be compiled.
The third argument indicated whether end-to-end encryption
is to be used
(\*(Lqyes\*(Rq and \*(Lqno\*(Rq are the only two acceptable values),
and if the fourth argument is \*(Lqyes\*(Rq,
.I rinstall
creates a subdirectory,
puts the programs the client needs in it,
and adds a makefile and a shell script to compile and install the programs.
These may then be moved to the client in a secure fashion;
this is useful if the networks are not trusted.
Saying \*(Lqno\*(Rq causes
.I rinstall
to do the installation itself.
.PP
If any argument is omitted or null,
the user is prompted for it.
Typing a blank line at that point causes
.I rinstall
to use a default,
or to repeat its request.
.SH EXAMPLES
.TP
rinstall prandtl prandtl/Environ yes no
Install the auditing programs as indicated by the environment file
.I prandtl/Environ
on the host \*(Lqprandtl\*(Rq.
End-to-end encryption is to be used;
.I rinstall is to do the remote installation itself.
.SH SEE ALSO
audit(8)
.SH AUTHOR
Matt Bishop
.RI ( mab@riacs.edu )
