:
#! /bin/sh
#
# This program determines which volume its argument is mounted on
# and prints the volume type.
#
# Usage:
#	gettype <file system root>
#
# Matt Bishop
# Research Institute for Advanced Computer Science
# NASA Ames Research Center
# Moffett Field, CA  94035
#
# mab@riacs.edu, ...!{decvax!decwrl,ihnp4!ames}!riacs!mab
#
# (c) Copyright 1988 by Matt Bishop and the Research Institute for
#			Advanced Computer Science
#
# version number
VERSION="RIACS Audit Package version 3.1.3 Tue May 19 12:59:43 PDT 1992 (Matt.Bishop@dartmouth.edu)"
#
#	system and shell variables
PATH=/usr/ucb:/bin:/usr/bin:%%DESTBIN%%	# execution path
export PATH				# for subprograms
#
# process the argument; be sure there is one and that it is an absolute
# path name
#
if test $# -ne 1
then
	echo "$0: need a file system name" 1>&2
	exit 1
elif expr "x$1" : '^x[^/].*' > /dev/null
then
	ARG="`pwd`/$1"
else
	ARG="$1"
fi
#
# go through the input a line at a time
#
while read X
do
	#
	# get the file volume name and its type; this relies on
	# the input lines having the form
	#    <partition/remote name> on <local name> type <type> (<properties>)
	# as in
	#	/dev/zd2h on /usr/local type 4.2 (rw)
	#
	FSNAME=`expr "x$X" : 'x.* on \([^ 	][^ 	]*\) .*'`
	TYPE=`expr "x$X" : 'x.* type \([^ 	][^ 	]*\)'`
	#
	# see if it matches a prefix of the argument
	#
	# if the volume is the root volume, ALWAYS match
	#
	if test "$FSNAME" = /
	then
		MATCH=1
		MATCHTYPE=$TYPE
		continue
	fi
	#
	# now see if the file volume is a prefix of the argument
	#
	if test "$FSNAME" = "$ARG" || expr "x$ARG" : "^x$FSNAME/" > /dev/null
	then
		#
		# we scored -- if it is longer than the previous match,
		# the current file volume is the right one and we update
		# the type
		#
		TMATCH=`expr "x$FSNAME" : 'x.*'`
		if test $TMATCH -gt $MATCH
		then
			MATCH=$TMATCH
			MATCHTYPE=$TYPE
		fi
	fi
done
#
# print the volume type and quit
#
echo $MATCHTYPE
exit 0
