/*
 * function:
 *	protect lines from the ed family of pattern matchers
 * usage:
 *	edprot [ chars ... ]
 * options:
 *	none
 * effect:
 *	copies standard input to output, protecting ed metacharacters
 *	and those characters given as arguments
 * exit status:
 *	0	worked
 * bugs:
 *
 *	Matt Bishop, Department of Mathematics and Computer Sciences,
 *	Bradley Hall, Dartmouth College, Hanover, NH  03755
 *	Internet: Matt.Bishop@dartmouth.edu
 *	UUCP/USENET: ...!{decvax,ihnp4}!dartvax!Matt.Bishop
 */
#include <stdio.h>

/*
 * version number
 */
static char *version = "RIACS Audit Package version 3.1.3 Tue May 19 12:59:43 PDT 1992 (Matt.Bishop@dartmouth.edu)";

#ifdef BSD4
#	define	METACH	"\\[.^*$"
#endif
#ifdef SYSV
#	define	index	strchr
#	define	METACH	".*[\\^$"
#endif

int metas[256];

main(argc, argv)
int argc;
char **argv;
{
	register int c;
	register char d;
	register char *p;

	for(p = METACH; *p; p++)
		metas[*p] = 1;
	for(c = 1;  c < argc; c++)
		for(p = argv[c]; *p; p++)
			metas[*p] = 1;

	/*
	 * process file a character at a time
	 */
	while((c = getchar()) != EOF){
		/*
		 * see if it's special: NUL is not
		 */
		if (metas[d = (char) c])
			putchar('\\');
		/*
		 * print it
		 */
		putchar(d);
	}
	/*
	 * done -- bye!
	 */
	exit(0);
}
