:
#! /bin/sh
FROMHOST=${1?"no client host named"}
TEST=${2?"no startup test(1) command given"}
ECHO=${3?"no startup echo(1) command given"}
%%NETREC%% | ( #
# List the contents of the directory or file system to be audited.
# We do this in a script because it makes remote auditing easy.
#
# Matt Bishop
# Research Institute for Advanced Computer Science
# NASA Ames Research Center
# Moffett Field, CA  94035
#
# mab@riacs.edu, ...!{decvax!decwrl,ihnp4!ames}!riacs!mab
#
# (c) Copyright 1986 by Matt Bishop and the Research Institute for
#			Advanced Computer Science
#
# version number
VERSION="RIACS Audit Package version 3.1.3 Tue May 19 12:59:43 PDT 1992 (Matt.Bishop@dartmouth.edu)"
#
FILESYS=				# audited file system
DEPTH=1					# how deep do we go
CAT=/bin/rm				# use this program for "cat(1)"
DELETE=/bin/rm				# use this program for "rm(1)"
EDIT=/bin/sed				# use this program for "sed(1)"
FIND=					# use this program for "auditfind(1)"
LIST=					# use this program for "lstat(1)"
PPND=					# use this program for "auditppnd(1)"
TYPEOPTS=				# options to "auditfind(1)"
#
FINDOPTS=
ALL=no
CHKLIST=/tmp/$$a
IGNLIST=/tmp/$$b
while read X Y
do
	case "$X" in
	'CALL')		CHKOPT=-x;;
	'CHKP')		CHECKSUMMER="$Y"; export CHECKSUMMER;;
	'DELF')		DELETE="$Y";;
	'FIND')		FIND="$Y";;
	'FSYS')		FILESYS="$Y";;
	'CHKF')		CHKOPT="$CHKOPT -C$Y";;
	'IGNF')		IGNOPT="$IGNOPT -I$Y";;
	'RECU')		DEPTH=10000;;
	'STRE')		EDIT="$Y";;
	'TEST')		TEST="$Y";;
	'TOPT')		FINDOPTS="$FINDOPTS $Y";;
	'FINL')		FINDOPTS="$FINDOPTS $Y";;
	'CHKL')		$ECHO "$Y" >> $CHKLIST;;
	'IGNL')		$ECHO "$Y" >> $IGNLIST;;
	'QUIT')		break;;
	*)		$ECHO "$0: unrecognized protocol command \"$X\"";;
	esac
done
#
# error checking
#
if $TEST -z "$DELETE"
then
	$ECHO "$0: remote rm(1) command not specified (DELF)"
	ABEND=yes
fi
if $TEST -z "$EDIT"
then
	$ECHO "$0: remote sed(1) command not specified (STRE)"
	ABEND=yes
fi
if $TEST -z "$FILESYS"
then
	$ECHO "$0: no file system specified (FSYS)"
	ABEND=yes
fi
if $TEST -z "$FIND"
then
	$ECHO "$0: remote auditfind(1) command not specified (FIND)"
	ABEND=yes
fi
if $TEST "$ABEND" = yes
then
	exit 1
fi
if $TEST -s "$CHKLIST"
then
	CHKOPT="$CHKOPT -c$CHKLIST"
else
	CHKOPT=
fi
if $TEST -s "$IGNLIST"
then
	IGNOPT="$IGNOPT -i$IGNLIST"
else
	IGNOPT=
fi
#
# change to the appropriate directory and get to work
#
$FIND '-vERRC %d' -d $DEPTH $FINDOPTS $TYPEOPTS $IGNOPT $CHKOPT \
	-lftpnugsxm $FILESYS | $EDIT 's/^/OUTP /'
#
# bye!
#
$DELETE -fr $CHKLIST $IGNLIST
exit 0 ) 2>&1 | %%NETSEND%%
