.\"
.\" Author:	Matt Bishop
.\" Address:	Research Institute for Advanced Computer Science
.\"		Mail Stop 230-5
.\"		NASA Ames Research Center
.\"		Moffett Field, CA  94035
.\" ARPA:	mab@riacs.arpa
.\" UUCP:	...!decvax!decwrl!riacs!mab
.\"		...!ihnp4!ames!riacs!mab
.\" Copyright:	(c) 1986 by Matt Bishop and the Research Institute for
.\"			Advanced Computer Science
.\"
.\" version
.ds Vr RIACS Audit Package version 3.1.3 Tue May 19 12:59:43 PDT 1992 (Matt.Bishop@dartmouth.edu)
.\"
.if n .ds Lq "
.if n .ds Rq "
.if t .ds Lq ``
.if t .ds Rq ''
.TH AUDIT 8
.SH NAME
audit \- audit a file system for possible security or accounting problems
.SH SYNOPSIS
.BR audit " [ "
.B \-1
] [
.BI \-a name1\f1,\fPname2\f1,\fP...
] [
.B \-C
] [
.BI \-c chkfile
] [
.B \-d
] [
.BI \-e envfile
] [
.BI \-f filesystem
] [
.B \-g
] [
.B \-ga
] [
.BI \-h host
] [
.BI \-i ignore
] [
.BI \-m master
] [
.BI \-n type1\f1,\f2type2\f1,\fP...
] [
.BI \-o type1\f1,\f2type2\f1,\fP...
] [
.BI \-p patmatser
] [
.BI \-r reject
] [
.B \-sb
] [
.B \-sc
] [
.B \-sG
] [
.B \-sg
] [
.B \-su
] [
.BI \-t timeout
] [
.B \-u
] [
.B \-v
] [
.B \-x
] [
.BI \-z tmpfile
]
.SH DESCRIPTION
.LP
.I Audit
scans the file system %%FILESYS%%,
and compares these results to information
in the master file %%LISTDIR%%/audit.lst.
It ignores any changes (additions, deletions) to the file system
if the name of the changed (added, deleted) file
matches prespecified patterns in %%LISTDIR%%/audit.ign
(these patterns are those used by
.IR ed (1))
and files named explicitly in %%LISTDIR%%/audit.rej,
and mails a description of all other differences found to
.I %%AUDITOR%% .
.LP
Options are:
.TP
.B \-1
Collect the output from all file systems audited in this run
and mail it to the auditor(s) in one letter.
Any errors will also be collected and sent in a separate letter.
.TP
.BI \-a name1\f1,\fPname2\f1,\fP...
Mail the results of the audit to
.IR name1 ,
.IR name2 ", ..."
rather than to
.IR %%AUDITOR%% .
.TP
.B \-C
Compute and record a checksum for each file scanned.
.TP
.BI \-c chkfile
Compute and record a checksum for each file listed in
.I chkfile .
.TP
.B \-d
Audit the base directory of the file system only
(in other words,
just the directory named in a
.B \-f
option,
or the default directories \*(Lqbin\*(Rq and \*(Lq/usr/bin\*(Rq.)
Do not audit any subdirectories.
.TP
.BI \-e envfile
Use
.I envfile
as the file containing the names of the commands used
to generate a listing of a file tree on a remote host;
the format is a keyword indicating the command being given,
the full name of the command on the remote host
and any comments;
the columns are separated by tabs.
The commands are
.I auditls
(remote listing script),
.I rsh
(command on local host to execute commands remotely),
.I ftype
(remote command to filter on the basis of file type),
.I find
(remote
.IR find (1)
command),
.I ls
(remote
.IR ls (1)
command),
.I lstat
(remote
.IR lstat (1)
command),
.I mount
(remote
.IR mount (8)
command),
and
.I test
(remote
.IR test (1)
command).
.TP
.BI \-f filesystem
Scan the named
.I filesystem
rather than the default %%FILESYS%%.
.TP
.B \-g
Construct the master list to be used for auditing the filesystem.
No audit is done.
.TP
.B \-ga
After auditing the file system,
replace the master file with the results of scanning the file system.
.TP
.BI \-h host
This option causes the audit to be run for the host
.IR host ,
rather than for the current machine.
Note this requires that certain programs be available on
.IR host ;
see the installation guide for details.
.TP
.BI \-i ignore
Ignore lines in the output that match
.IR egrep (1)-style
patterns in the file
.I ignore
rather than in the default %%LISTDIR%%/audit.ign.
Be aware that the audit program will change to the directory being audited,
so use path names relative to that directory;
absolute path names do nothing.
.TP
.BI \-m master
Compare the results of the audit with the list in
.IR master
rather than in %%LISTDIR%%/audit.lst.
If the
.B \-g
or
.B \-ga
flag is given,
the results of the audit are saved in this file.
.TP
.BI \-n type1\f1,\fPtype2\f1,\fP...
If the
.I filesystem
is mounted on a volume of type
.IR type1 ,
.IR type2 ", ..."
do not audit it.
This is useful when auditing multiple systems
that allow remote mounting of file systems such as NFS.
.TP
.BI \-o type1\f1,\fPtype2\f1,\fP...
If the
.I filesystem
is not mounted on a volume of type
.IR type1 ,
.IR type2 ", ..."
do not audit it.
It is the exact opposite of the option
.BR \-n .
.TP
.BI \-p patmaster
Compare added and deleted files to the entries in
.,I patmaster
rather than in %%LISTDIR%%/audit.pat.
.TP
.BI \-r reject
Ignore changes made to the files named in this file
rather than in the default %%LISTDIR%%/audit.rej.
Each file must be named by its full path name;
to ignore subtrees,
name the directory at the root of the tree and end with a slash \*(Lq/\*(Rq.
These files differ from ignore files in two ways:
first,
no pattern matching of any kind is done on the names,
and second,
if the reject file has not been modified in
%%LIMIT%% days,
it is deleted before any checking is done.
The purpose of this file is to enable system administrators
to install new programs and then suppress the
message that this would produce when
.I audit
is next run.
.TP
.B \-sb
Confine reporting to those files which are block special device files;
if this option and any of the other
.B \-s
options are given,
reporting is confined to those files matching one or more
of the charctersitics.
.TP
.B \-sc
Confine reporting to those files which are character special device files.
If this option and any of the other
.B \-s
options are given,
reporting is confined to those files matching one or more
of the charcteristics.
.TP
.B \-sG
Confine reporting to those files which are setgid
(\f2i.e.,\fP have the 02000 bit in the permissions flags set)
and
.B not
directory files;
if this option and any of the other
.B \-s
options are given,
reporting is confined to those files matching one or more
of the charcteristics.
.TP
.B \-sg
Confine reporting to those files which are setgid
(\f2i.e.,\fP have the 02000 bit in the permissions flags set.)
If this option and any of the other
.B \-s
options are given,
reporting is confined to those files matching one or more
of the charctersitics.
.TP
.B \-su
Confine reporting to those files which are setuid
(\f2i.e.,\fP have the 04000 bit in the permissions flags set.)
If this option and any of the other
.B \-s
options are given,
reporting is confined to those files matching one or more
of the charctersitics.
.TP
.BI \-t timeout
If the listing command is not active for
.I timeout
seconds (default %%TIMEOUT%%),
assume the network has failed and abort the audit.
If
.I timeout
is 0,
.I runaudit
will not time out the listing command.
This is quite useful in an environment with unreliable networking.
.TP
.B \-u
Every user who owns a file that has been added,
deleted,
or changed will be mailed a message describing the change.
This message looks like an audit report.
If a file's ownership changes,
both the new and old owner will be told about it.
.TP
.B \-u
Every user who owns a file that has been added,
deleted,
or changed will be mailed a message describing the change.
This message looks like an audit report.
If a file's ownership changes,
both the new and old owner will be told about it.
.TP
.B \-v
This is a debugging option,
and causes all input lines to be printed as they are read.
It is the same as giving the
.B \-v
option to
.IR sh (1).
This option generates lots of output.
.TP
.B \-x
This is a debugging option,
and causes all commands and arguments to be printed as they are executed.
It is the same as giving the
.B \-x
option to
.IR sh (1).
This option generates lots of output.
.SH EXAMPLES
.TP
audit -g -m/usr/adm/audit/Master.bin -f/bin
This generates a master list of files in /bin
to be used in future audits of /bin
The file is named /usr/adm/audit/Master.bin.
.TP
audit -m/usr/adm/audit/Master.bin -f/bin -astaff
Audit /bin,
comparing the files there against those in the master list
generated in the previous example.
A letter describing the differences will be mailed to \*(Lqstaff\*(Rq
(by default,
the letter is mailed to \*(Lqroot\*(Rq;
the
.B \-a
option changes this.)
.TP
audit -g -munsupported -iunsupported.ign
This generates a master list of files in /usr/unsupported
to be used in future audits of /usr/unsupported.
The file is named \*(Lqunsupported\*(Rq.
Files with audit lines that match lines in \*(Lqunsupported.ign\*(Rq
are ignored;
for example,
to exclude any spool files from the audit,
the file \*(Lqunsupported.ign\*(Rq should contain the line
.ce
^/usr/unsupported/spool/
.TP
audit -anasops,staff -munsupported -iunsupported.ign -u
Audit /usr/unsupported,
comparing the files there against those in the master list
generated in the previous example.
A letter describing the differences will be mailed to \*(Lqnasops\*(Rq
and \*(Lqstaff\*(Rq.
Also,
each user who owns a file named in the audit
will receive a letter informing him or her if any of his or her files
have changed.
.TP
audit -anasops,staff -ga -sg -su -msetguid -f/
Audit all files which are setuid and/or setgid,
comparing the files there against those in the master list \*(Lqsetguid\*(Rq.
A letter describing the differences will be mailed to \*(Lqnasops\*(Rq
and \*(Lqstaff\*(Rq.
Then,
the master file \*(Lqsetguid\*(Rq will be replaced with
the current list of setuid and setgid programs.
.SH FILES
\&%%LISTDIR%%/audit.lst	default master list
.br
\&%%LISTDIR%%/audit.pat	default pattern master list
.br
\&%%LISTDIR%%/audit.ign	default ignore list
.br
\&%%LISTDIR%%/audit.rej	default ignore list
.br
\&%%TMPDIR%%/Au\f2nnnnnn\fP	temporary files
.SH SEE ALSO
auditfmt(8),
auditgrep(8),
auditmail(8),
auditscan(1),
gettype(8),
runaudit(8)
.br
\f2The RIACS Intelligent Audit and Categorizing System\fP, Matt Bishop
.SH AUTHOR
Matt Bishop
.RI ( mab@riacs.edu )
