/*
 * This program is an implementation of the ISAKMP Internet Standard.
 * Copyright (C) 1997 Angelos D. Keromytis.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * This code was written while the author was in Greece, in May/June
 * 1997.
 *
 * You may contact the author by:
 *   e-mail: angelos@dsl.cis.upenn.edu
 *  US-mail: Angelos D. Keromytis
 *           Distributed Systems Lab
 *           Computer and Information Science Department
 *           University of Pennsylvania
 *           Moore Building
 *           200 South 33rd Street
 *           Philadelphia, PA 19104	   
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "constants.h"
#include "state.h"
#include "packet.h"
#include "defs.h"

/*
 * This file does basic header checking and demux of
 * incoming packets.
 */

/*
 * Receive a packet.
 */
void
comm_handle(int kernelfd, int sock)
{
    u_char *buffer;
    int length, i;
    struct sockaddr_in sin;
    struct isakmp_hdr *isa;
    struct state *st;

    length = sizeof(sin);

#ifndef linux
    /* Find how large is this message */
    i = recvfrom(sock, nullbuffer, UDP_SIZE, MSG_PEEK, (struct sockaddr *)&sin,
		 &length);
    if (i == -1)
    	exit_log("recvfrom() failed in comm_handle()", 0, 0, 0);

    /* Allocate exactly that much space */
    buffer = (u_char *) calloc(i, sizeof(u_char));
    if (buffer == (u_char *) NULL)
      exit_log("calloc() failed in comm_handle()", 0, 0, 0);
#else
    i = UDP_SIZE;
    bzero(&sin, sizeof(sin));
    sin.sin_family = AF_INET;
#endif

    /* Now really read the message */
    if ((i = recvfrom(sock, buffer, i, 0, (struct sockaddr *)&sin, &length))
	== -1)
    {
	log(1, "recvfrom() failed in comm_handle", 0, 0, 0);
#ifndef linux
	free(buffer);
#endif
	return;
    }

#ifdef linux
    /* Allocate exactly that much space */
    buffer = (u_char *) calloc(i, sizeof(u_char));
    if (buffer == (u_char *) NULL)
      exit_log("calloc() failed in comm_handle()", 0, 0, 0);

    bcopy(nullbuffer, buffer, i);
#endif

#ifdef DEBUG
    log(0, "read %d bytes from %s, port %d", i,
	(get_address(sin) != (char *) NULL ? get_address(sin) :
	 "(unknown address family)"), get_port(sin));
#endif

    isa = (struct isakmp_hdr *) buffer;

    /* XXX */
}
