/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	    Copyright (C) 1996, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
  *
  */

/*
 * $Id: tncfg.c,v 0.5 1997/06/03 04:31:55 ji Rel $
 *
 * $Log: tncfg.c,v $
 * Revision 0.5  1997/06/03 04:31:55  ji
 * New file.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <linux/types.h>
#include <linux/if.h>

struct ipsectunnelconf
{
	__u32	cf_cmd;
	union
	{
		char 	cfu_name[12];
	} cf_u;
#define cf_name cf_u.cfu_name
};

#define IPSEC_SET_DEV	(SIOCDEVPRIVATE)

void usage(char *name)
{	
	fprintf(stderr,"%s attach <virtual-device> <real-device>\n", name);
	exit(1);
}

void main(int argc, char *argv[])
{
	int s=socket(AF_INET, SOCK_DGRAM,0);
	if(s==-1)
	{
		perror("socket");
		exit(1);
	}
	if(argc!=4)
		usage(argv[0]);
	if(strcmp(argv[1],"attach")==0)
	{
		struct ifreq ifr;
		struct ipsectunnelconf *shc=(struct ipsectunnelconf *)&ifr.ifr_data;
		strcpy(ifr.ifr_name, argv[2]);
		strcpy(shc->cf_name, argv[3]);
		shc->cf_cmd = IPSEC_SET_DEV;
		if(ioctl(s, IPSEC_SET_DEV, &ifr)==-1)
		{
			perror("attach");
			exit(1);
		}
		exit(0);
	}
	usage(argv[0]);
}
