/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: ipsec_netlink.h,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_netlink.h,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * No changes.
 *
 * Revision 0.3  1996/11/20 14:39:04  ji
 * Minor cleanups.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

/*
 * IPSEC <> netlink interface
 */

#define EM_MAXRELSPIS	4		/* at most five chained xforms */
#define EM_MAGIC	0x5377616e	/* "Swan" */

struct encap_msghdr
{
	__u32	em_magic;		/* EM_MAGIC */
	__u16	em_msglen;		/* message length */
	__u8	em_version;		/* for future expansion */
	__u8	em_type;		/* message type */
	union
	{
		__u8	C;		/* Free-text */
		
		struct 
		{
			struct sockaddr_encap Eaddr;
			struct sockaddr_encap Emask;
			struct in_addr Dst;
			__u32 Spi;
		} Ert;

		struct
		{
			struct in_addr Ia;
			__u8	Ifn;
			__u8  xxx[3];	/* makes life a lot easier */
		} Ifa;

		struct
		{
			__u32 Spi;	/* SPI */
			struct in_addr Dst; /* Destination address */
			int If;		/* enc i/f for input */
			int Alg;	/* Algorithm to use */
			__u8 Dat[1];	/* Data */
		} Xfm;
		
		struct
		{
			__u32 emr_spi;	/* SPI */
			struct in_addr emr_dst; /* Dest */
			struct tdb * emr_tdb; /* used internally! */
			
		} Rel[EM_MAXRELSPIS];
	} Eu;
};

#define em_c	Eu.C
#define em_eaddr Eu.Ert.Eaddr
#define em_emask Eu.Ert.Emask
#define em_erdst Eu.Ert.Dst
#define em_erspi Eu.Ert.Spi

#define em_ifa	Eu.Ifa.Ia
#define em_ifn	Eu.Ifa.Ifn

#define em_spi	Eu.Xfm.Spi
#define em_dst	Eu.Xfm.Dst
#define em_if	Eu.Xfm.If
#define em_alg	Eu.Xfm.Alg
#define em_dat	Eu.Xfm.Dat

#define em_rel	Eu.Rel

#define EMT_IFADDR	1		/* set enc if addr */
#define EMT_SETSPI	2		/* Set SPI properties */
#define EMT_GRPSPIS	3		/* Group SPIs (output order)  */
#define EMT_SETEROUTE	4		/* set an extended route */
#define EMT_DELEROUTE	5		/* del an extended route */
#define EMT_TESTROUTE	6		/* try to find route, print to console */


#define EM_MINLEN	8		/* count!!! */
#define EMT_IFADDR_LEN	12
#define EMT_SETSPI_FLEN	24
#define EMT_GRPSPIS_FLEN 8


extern int ipsec_callback(struct sk_buff *skb);

#ifdef DEBUG_IPSEC_NETLINK

extern int debug_netlink;

#define DB_NL_TDBCB	0x0001

#endif


