/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: ipsec_ahmd5.c,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_ahmd5.c,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * Minor cosmetic changes.
 *
 * Revision 0.3  1996/11/20 14:35:48  ji
 * Minor Cleanup.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

#include <linux/config.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/config.h>

#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/icmp.h>
#include <linux/udp.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/sock.h>
#include <net/icmp.h>

#include <net/checksum.h>

#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>

#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>

#include <net/netlink.h>
#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_radij.h"
#include "ipsec_netlink.h"
#include "ipsec_xform.h"
#ifdef CONFIG_IPSEC_AH
#include "ipsec_ah.h"
#endif

static u_long md5zeroes[64];

#ifdef NOLONGER_DEBUG_IPSEC_AH
static void
print_ip(struct iphdr *ip)
{
	unsigned char *ipaddr;

	printk("IP packet:\n");
	printk("--- header len = %d\n", ip->ihl*4);
	printk("--- ip version: %d\n", ip->version);
	printk("--- ip protocol: %d\n", ip->protocol);
	ipaddr=(unsigned char *)&ip->saddr;
	printk("--- source address: %u.%u.%u.%u\n", 
			*ipaddr, *(ipaddr+1), *(ipaddr+2), *(ipaddr+3));
	ipaddr=(unsigned char *)&ip->daddr;
	printk("--- destination address: %u.%u.%u.%u\n", 
			*ipaddr, *(ipaddr+1), *(ipaddr+2), *(ipaddr+3));
	printk("--- total packet len: %d\n", ntohs(ip->tot_len));
}
#endif

struct sk_buff *
ahmd5_input(struct sk_buff *skb, struct tdb *tdbp)
{
	struct iphdr *ipp, ipo;
	struct ahmd5_xdata *xd;
	struct ah aho;
	struct ah *ahp;
	int iphlen, authlen, proto, len;
#ifdef DEBUG_IPSEC_AH
	int i;
#endif
	unsigned char *dat;
	MD5_CTX ctx; 
	
	len = skb->len; dat = skb->data;

	ipp = (struct iphdr *)dat;
	iphlen = ipp->ihl << 2;
	ahp = (struct ah *)(dat + iphlen);
	
	authlen = (ahp->ah_hl << 2) + AH_FLENGTH;
	proto = ahp->ah_nh;
	
	xd = (struct ahmd5_xdata *)tdbp->tdb_xdata;

	if ((authlen - AH_FLENGTH) != xd->amx_alen)
	{
#ifdef DEBUG_IPSEC_AH
		if (debug_ah & DB_AH_INAU)
			printk("ahmd5_input: bad authenticator length %d, expected %d\n", authlen, xd->amx_alen);
#endif
	}

	ipo = *ipp;
	ipo.tos = 0;
	ipo.frag_off = htons(ntohs(ipo.frag_off) & IP_DF);	/* XXX -- and the C bit? */
	ipo.ttl = 0;
	ipo.check = 0;

	MD5Init(&ctx);
	MD5Update(&ctx, (unsigned char *)xd->amx_key, xd->amx_klen);
	MD5Final(NULL, &ctx);		/* non-std usage of MD5Final! */
	MD5Update(&ctx, (unsigned char *)&ipo, sizeof (struct iphdr));
	MD5Update(&ctx, (unsigned char *)ahp, AH_FLENGTH);
	MD5Update(&ctx, (unsigned char *)md5zeroes, xd->amx_alen);

	MD5Update(&ctx,  dat + iphlen + authlen, len - iphlen - authlen);

	MD5Update(&ctx, (unsigned char *)xd->amx_key, xd->amx_klen);
	MD5Final((unsigned char *)(&(aho.ah_data[0])), &ctx);
	
	if (memcmp(aho.ah_data, ahp->ah_data, xd->amx_alen))
	{
#ifdef DEBUG_IPSEC_AH
		if (debug_ah & DB_AH_INAU)
			printk("ahmd5_input: bad auth\n");
#endif
		return NULL;
	}

	/*
	 *	Discard the original IP header
	 */
	 
	ipp->tot_len = htons(ntohs(ipp->tot_len) - authlen);
	ipp->protocol = proto;

	memmove((void *)(skb->data + authlen), (void *)skb->data, iphlen);

	skb_pull(skb, authlen);

	/*
	 *	Adjust pointers
	 */
	 
	
	len = skb->len; dat = skb->data;
	
#ifdef DEBUG_IPSEC_AH
	if (debug_ah & DB_AH_PKTRX2)
	{
		printk("ipsec_ah: new ip packet is %d bytes:", len);
		for (i = 0; i < len; i++)
			printk(" %02x", dat[i]);
		printk("\n");
	}
#endif

	skb->h.iph=(struct iphdr *)skb->data;
	skb->ip_hdr=(struct iphdr *)skb->data;

	memset(skb->proto_priv, 0, sizeof(struct options));
	
	ipp = (struct iphdr *)dat;
	ipp->check = ip_fast_csum((unsigned char *)dat, iphlen >> 2);

	return skb;
}

int
ahmd5_attach(void)
{
	printk("ahmd5_attach: called.\n");
	return 0;
}

/*
 * ahmd5_init() is called when an SPI is being set up. It interprets the
 * encap_msghdr present in m, and sets up the transformation data.
 */

int
ahmd5_init(struct tdb *tdbp, struct xformsw *xsp, struct encap_msghdr *em)
{
	struct ahmd5_xdata *xd;
	
	tdbp->tdb_xform = xsp;


	tdbp->tdb_xdata = (caddr_t)kmalloc(sizeof (struct ahmd5_xdata), GFP_ATOMIC); /* XXX - memory leak here if updating old TDB */

	if (tdbp->tdb_xdata == NULL)
	  return ENOBUFS;
	memset(tdbp->tdb_xdata, 0, sizeof (struct ahmd5_xdata));
	xd = (struct ahmd5_xdata *)tdbp->tdb_xdata;

	if (em->em_msglen - EMT_SETSPI_FLEN > sizeof (struct ahmd5_xdata))
	{
		kfree((caddr_t)tdbp->tdb_xdata);
		tdbp->tdb_xdata = NULL;
		return EINVAL;
	}
	
	memcpy((caddr_t)xd, em->em_dat, em->em_msglen - EMT_SETSPI_FLEN);
	return 0;
}



int ahmd5_zeroize(void)
{
	return 0;
}

int ahmd5_print(void *xdat, char *buf)
{
	int size;
#ifdef AHPRINTKEYS
	int ds, i;
#endif
	struct ahmd5_xdata *xd = (struct ahmd5_xdata *)xdat;
	size = sprintf(buf, "klen = %d, alen = %d", xd->amx_klen, xd->amx_alen);
	buf += size;
#ifdef AHPRINTKEYS
	/* XXX - print the key in /proc/net/ipsec-spi !!! */
	ds = sprintf(buf, ", key = ");
	buf += ds;
	size += ds;
	for (i = 0; i < xd->amx_klen; i++){
		ds = sprintf(buf, " %02x", xd->amx_key[i]);
		buf += ds;
		size += ds;
	}
#endif
	return size;
}

int
ahmd5_room(struct tdb *tp, int iphlen, int tlen, int *hr, int *tr)
{
	struct ahmd5_xdata *xd = (struct ahmd5_xdata *)(tp->tdb_xdata) ;
	
	*hr += xd->amx_alen + AH_FLENGTH;
	*tr += 0;
	return 0;
}

int ahmd5_output(struct sk_buff *skb, struct tdb *tdbp)
{
	struct iphdr *ipp, ipo;
	struct ahmd5_xdata *xd;
	struct ah aho;
	struct ah *ahp;
	int iphlen, authlen, len;
	unsigned char *dat;
	MD5_CTX ctx; 
	
	ipp = (struct iphdr *)(skb->data);
	
	iphlen = ipp->ihl << 2;
	if (iphlen != sizeof (struct iphdr))
	{
		printk("ahmd5_output: cannot process options yet\n"); /* XXX */
		return -1;
	}

	xd = (struct ahmd5_xdata *)tdbp->tdb_xdata;
	authlen = xd->amx_alen + AH_FLENGTH; /* same as in xxx_room() */

	dat = skb_push(skb, authlen);
	len = skb->len;
	
	memmove((void *)skb->data, (void *)(skb->data + authlen), iphlen);
	ahp = (struct ah *)(dat + iphlen);

	ipp = (struct iphdr *)dat;

	if (ntohs(ipp->frag_off) & IP_OFFSET)
	{
		printk("ahmd5_output: attempted to authenticate fragment!\n"); /* XXX */
		return -1;
	}

	ahp->ah_nh = ipp->protocol;
	ahp->ah_hl = (authlen - AH_FLENGTH) >> 2;
	ahp->ah_rv = 0;
	ahp->ah_spi = tdbp->tdb_spi;
	
	ipp->protocol		=	51;
	ipp->tot_len		=	htons(skb->len);

	ipo = *ipp;
	ipo.tos = 0;
	ipo.frag_off = htons(ntohs(ipo.frag_off) & IP_DF);	/* XXX -- and the C bit? */
	ipo.ttl = 0;
	ipo.check = 0;

	MD5Init(&ctx);
	MD5Update(&ctx, (unsigned char *)xd->amx_key, xd->amx_klen);
	MD5Final(NULL, &ctx);		/* non-std usage of MD5Final! */
	MD5Update(&ctx, (unsigned char *)&ipo, sizeof (struct iphdr));
	MD5Update(&ctx, (unsigned char *)ahp, AH_FLENGTH);
	MD5Update(&ctx, (unsigned char *)md5zeroes, xd->amx_alen);

	MD5Update(&ctx,  dat + iphlen + authlen, len - iphlen - authlen);

	MD5Update(&ctx, (unsigned char *)xd->amx_key, xd->amx_klen);
	MD5Final((unsigned char *)(&(aho.ah_data[0])), &ctx);
	
	memcpy(ahp->ah_data, aho.ah_data, xd->amx_alen);

	skb->ip_hdr = skb->h.iph = (struct iphdr *) skb->data;
	
	ipp->check = 0;
	ipp->check = ip_fast_csum((unsigned char *)ipp, ipp->ihl);

	return 0;
}
