/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: ipsec_xform.c,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_xform.c,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * Added new transforms.
 *
 * Revision 0.3  1996/11/20 14:39:04  ji
 * Minor cleanups.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

#include <linux/config.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/config.h>

#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/icmp.h>
#include <linux/udp.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/sock.h>
#include <net/icmp.h>

#include <net/checksum.h>

#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>

#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>

#include <net/netlink.h>
#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_radij.h"
#include "ipsec_netlink.h"
#include "ipsec_xform.h"

#include "ipsec_ipe4.h"

#ifdef CONFIG_IPSEC_AH
#include "ipsec_ah.h"
#endif

#ifdef CONFIG_IPSEC_ESP
#include "ipsec_esp.h"
#endif

#ifdef DEBUG_IPSEC_XFORM
int debug_xform = 0;
#endif

/*
 * Common routines for IPSEC transformations.
 */

struct xformsw xformsw[] = {
{ XF_IP4,		0,		"IPv4 Simple Encapsulation",
  ipe4_attach,		ipe4_init,	ipe4_zeroize,
  ipe4_print,		ipe4_room,
  ipe4_input,	ipe4_output, },
#ifdef CONFIG_IPSEC_AH_MD5
{ XF_AHMD5,		XFT_AUTH,	"Keyed MD5 Authentication",
  ahmd5_attach,		ahmd5_init,	ahmd5_zeroize,	
  ahmd5_print,		ahmd5_room,
  ahmd5_input,		ahmd5_output, },
#endif
#ifdef CONFIG_IPSEC_ESP_DES_CBC
{ XF_ESPDES,		XFT_CONF,	"DES-CBC Encryption",
  espdes_attach,	espdes_init,	espdes_zeroize,
  espdes_print,		espdes_room,
  espdes_input,		espdes_output, },
#endif
#ifdef CONFIG_IPSEC_AH_HMAC_MD5
{ XF_AHHMACMD5,		XFT_AUTH,	"HMAC MD5 Authentication",
  ahhmacmd5_attach,	ahhmacmd5_init,	ahhmacmd5_zeroize,	
  ahhmacmd5_print,	ahhmacmd5_room,
  ahhmacmd5_input,	ahhmacmd5_output, },
#endif
#ifdef CONFIG_IPSEC_AH_HMAC_SHA1
{ XF_AHHMACSHA1,	XFT_AUTH,	"HMAC SHA-1 Authentication",
  ahhmacsha1_attach,	ahhmacsha1_init,	ahhmacsha1_zeroize,	
  ahhmacsha1_print,	ahhmacsha1_room,
  ahhmacsha1_input,	ahhmacsha1_output, },
#endif
#ifdef CONFIG_IPSEC_ESP_DES_MD5
{ XF_ESPDESMD5,		XFT_CONF,	"DES-MD5 Encryption",
  espdesmd5_attach,	espdesmd5_init,	espdesmd5_zeroize,
  espdesmd5_print,	espdesmd5_room,
  espdesmd5_input,	espdesmd5_output, },
#endif
#ifdef CONFIG_IPSEC_ESP_3DES_MD5
{ XF_ESP3DESMD5,	XFT_CONF,	"3DES-MD5 Encryption",
  esp3desmd5_attach,	esp3desmd5_init,	esp3desmd5_zeroize,
  esp3desmd5_print,	esp3desmd5_room,
  esp3desmd5_input,	esp3desmd5_output, },
#endif
};

struct xformsw *xformswNXFORMSW = &xformsw[sizeof(xformsw)/sizeof(xformsw[0])];

struct tdb *
gettdb(u_long spi, struct in_addr dst)
{
	int hashval;
	struct tdb *tdbp;
	
	hashval = (spi+dst.s_addr) % TDB_HASHMOD;
	
	for (tdbp = tdbh[hashval]; tdbp; tdbp = tdbp->tdb_hnext)
	  if ((tdbp->tdb_spi == spi) && (tdbp->tdb_dst.s_addr == dst.s_addr))
	    break;
	
	return tdbp;
}

void
puttdb(struct tdb *tdbp)
{
	int hashval;
	hashval = ((tdbp->tdb_spi + tdbp->tdb_dst.s_addr) % TDB_HASHMOD);
	tdbp->tdb_hnext = tdbh[hashval];
	tdbh[hashval] = tdbp;
}

int
tdb_init(struct tdb *tdbp, struct encap_msghdr *em)
{
	int alg;
	struct xformsw *xsp;
	
	alg = em->em_alg;

	for (xsp = xformsw; xsp < xformswNXFORMSW; xsp++)
	  if (xsp->xf_type == alg)
	    return (*(xsp->xf_init))(tdbp, xsp, em);

#ifdef DEBUG_IPSEC_XFORM
	if (debug_xform & DB_XF_INIT)
	  printk("tdbinit: no alg %d for spi %x, addr %x\n", alg, (u_int)tdbp->tdb_spi, (u_int)ntohl(tdbp->tdb_dst.s_addr));
#endif
	return EINVAL;
}
