/*
 * $Id: ipsec_sha1.h,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_sha1.h,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * New transform
 *
 */

/*
 * Here is the original comment from the distribution:

SHA-1 in C
By Steve Reid <steve@edmweb.com>
100% Public Domain

 * Adapted for use by the IPSEC code by John Ioannidis
 */


#ifndef _IPSEC_SHA1_H_
#define _IPSEC_SHA1_H_

#include <asm/byteorder.h>
#include <linux/string.h>

typedef struct
{
	__u32	state[5];
	__u32	count[2];
	__u8	buffer[64];
} SHA1_CTX;

void SHA1Transform(__u32 state[5], __u8 buffer[64]);
void SHA1Init(SHA1_CTX *context);
void SHA1Update(SHA1_CTX *context, unsigned char *data, unsigned int len);
void SHA1Final(unsigned char digest[20], SHA1_CTX *context);

 
#endif _IPSEC_SHA1_H_
