/*
 * The author of this code is John Ioannidis, ji@tla.org,
 * 	(except when noted otherwise).
 *
 * This code was written in Athens, Greece, in November 1995.
 *
 * Copyright (C) 1995, by John Ioannidis.
 *	
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software.
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTY. IN PARTICULAR, THE AUTHOR DOES NOT MAKE ANY
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

#ifndef lint
static char rcsid[] = "$Id: ip_ipsp.c,v 1.1 1995/11/29 14:33:50 ji Exp $";
#endif

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/malloc.h>
#include <sys/mbuf.h>
#include <sys/domain.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <sys/kernel.h>

#include <net/if.h>
#include <net/route.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/in_pcb.h>
#include <netinet/in_var.h>
#include <netinet/ip_var.h>
#include <netinet/ip_icmp.h>

#include <net/raw_cb.h>
#include <net/encap.h>

#include <netinet/ip_ipsp.h>
#include <netinet/ip_ip4.h>
#include <netinet/ip_ah.h>
#include <netinet/ip_esp.h>

#ifdef ENCDEBUG
int encdebug = 1;
#endif

/*
 * This is the proper place to define the various encapsulation transforms.
 */

struct xformsw xformsw[] = {
{ XF_IP4,		0,		"IPv4 Simple Encapsulation",
  ipe4_attach,		ipe4_init,	ipe4_zeroize,
  ipe4_input,	ipe4_output, },

{ XF_AHMD5,		XFT_AUTH,	"Keyed MD5 Authentication",
  ahmd5_attach,		ahmd5_init,	ahmd5_zeroize,
  ahmd5_input,		ahmd5_output, },

{ XF_ESPDES,		XFT_CONF,	"DES-CBC Encryption",
  espdes_attach,	espdes_init,	espdes_zeroize,
  espdes_input,	espdes_output, },
};

struct xformsw *xformswNXFORMSW = &xformsw[sizeof(xformsw)/sizeof(xformsw[0])];

/*
 * An IPSP SAID is really the concatenation of the SPI found in the 
 * packet and the destination address of the packet. When we receive
 * an IPSP packet, we need to look up its tunnel descriptor block, 
 * based on the SPI in the packet and the destination address (which is
 * really one of our addresses if we received the packet!
 */

struct tdb *
gettdb(u_long spi, struct in_addr dst)
{
	int hashval;
	struct tdb *tdbp;
	
	hashval = (spi+dst.s_addr) % TDB_HASHMOD;
	
	for (tdbp = tdbh[hashval]; tdbp; tdbp = tdbp->tdb_hnext)
	  if ((tdbp->tdb_spi == spi) && (tdbp->tdb_dst.s_addr == dst.s_addr))
	    break;
	
	return tdbp;
}

void
puttdb(struct tdb *tdbp)
{
	int hashval;
	hashval = ((tdbp->tdb_spi + tdbp->tdb_dst.s_addr) % TDB_HASHMOD);
	tdbp->tdb_hnext = tdbh[hashval];
	tdbh[hashval] = tdbp;
}

int
tdb_init(struct tdb *tdbp, struct mbuf *m)
{
	int alg;
	struct encap_msghdr *em;
	struct xformsw *xsp;
	
	em = mtod(m, struct encap_msghdr *);
	alg = em->em_alg;

	for (xsp = xformsw; xsp < xformswNXFORMSW; xsp++)
	  if (xsp->xf_type == alg)
	    return (*(xsp->xf_init))(tdbp, xsp, m);

	printf("tdbinit: no alg %d for spi %x, addr %x\n", alg, tdbp->tdb_spi, ntohl(tdbp->tdb_dst));
	
	m_freem(m);
	return EINVAL;
}
