/*
 * SNK support for logdaemon
 *
 * Written by William LeFebvre, Argonne National Laboratory
 */

/* file name definitions:
 * SCFILE - contains username to SNK serial number pairs
 * SCMAP - YP map to try for SCFILE data
 * SNKFILE - contains serial number to DES key pairs
 */

#define SCFILE "/etc/snkcards"
#define SCMAP "snkcards.byname"
#define SNKFILE "/etc/snkkeys"

/* definitions for non-int functions */
char *snk_challenge();
long randomnumber();

/* describe an SCFILE entry */
struct scent {
    char *name;		/* username */
    char *serial;	/* serial number (any arbitrary string) */
};

/* describe an SNKFILE entry */
struct snkent {
    char *id;		/* card serial number */
    char *key;		/* DES key: space separated octal bytes */
    char *cksum;	/* checksum: six hex digits */
};

