/*
 * snk_encrypt
 *
 * Part of the SNK extension to logdaemon
 *
 * Written by William LeFebvre, Argonne National Laboratory
 */

#include <sys/types.h>
#include <stdio.h>
#include <des.h>

/*
 * void snk_encrypt(char *data, char *key)
 *	Encrypt data in string "data" using "key" as the key.  Data is
 *	encrypted in place.  This function calls DES routines to perform
 *	encryption, but it could easily be rewritten to accomodate other
 *	encryption techniques.
 */

snk_encrypt(data, key)

char *data;
char *key;

{
    des_cblock dc_key;
    des_key_schedule key_schedule;
    des_cblock dc_in;
    des_cblock dc_out;
    register int i;

    /* copy the key over to a des_block */
    for (i = 0; i < DES_KEY_SZ; i++)
    {
	dc_key[i] = key[i];
    }

    /* set the key */
    des_set_key(&dc_key, key_schedule);

    /* copy the input data over to a des_block */
    for (i = 0; i < DES_KEY_SZ; i++)
    {
	dc_in[i] = data[i];
    }

    des_ecb_encrypt(&dc_in, &dc_out, key_schedule, ENCRYPT);

    /* copy the output back */
    for (i = 0; i < DES_KEY_SZ; i++)
    {
	data[i] = dc_out[i];
    }

    return;
}
