/* logwtmp - record login or logout in wtmp(x) file */

#include <utmpx.h>

logwtmp(line, user, host)
char   *line;
char   *user;
char   *host;
{
    struct utmpx utx;

    memset((char *) &utx, 0, sizeof(utx));
    strncpy(utx.ut_user, user, sizeof(utx.ut_user));
    strncpy(utx.ut_id, line, sizeof(utx.ut_id));	/* XXX */
    strncpy(utx.ut_line, line, sizeof(utx.ut_line));
    utx.ut_pid = getpid();
    utx.ut_type = *user ? USER_PROCESS : DEAD_PROCESS;
    gettimeofday(&(utx.ut_tv));
    utx.ut_session = 0;
    if ((utx.ut_syslen = strlen(host)) > sizeof(utx.ut_host))
	utx.ut_syslen = sizeof(utx.ut_host);
    strncpy(utx.ut_host, host, utx.ut_syslen);

    updwtmpx(WTMPX_FILE, &utx);
}
