 /*
  * Minimal shell, for use with popen(3) only. Does not understand any shell
  * meta characters, and therefore refuses any command that contains them.
  * Refuses commands with BUFSIZ or more components. Drops root privileges if
  * compiled with -DUSER and -DGROUP.
  * 
  * Wietse Venema (wietse@porcupine.org) 20010614
  */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#ifdef USER
#include <pwd.h>
#include <grp.h>

static void drop_privileges()
{
    struct passwd *pwd;
    struct group *grp;

    if ((pwd = getpwnam(USER)) == 0) {
	fprintf(stderr, "bad user name: %s\n", USER);
	exit(1);
    }
    if ((grp = getgrnam(GROUP)) == 0) {
	fprintf(stderr, "bad group name: %s\n", GROUP);
	exit(1);
    }
    if (setgid(grp->gr_gid) < 0) {
	fprintf(stderr, "cannot set group ID: %d\n", grp->gr_gid);
	exit(1);
    }
    if (setgroups(1, &grp->gr_gid) < 0) {
	fprintf(stderr, "cannot set groups: %d\n", grp->gr_gid);
	exit(1);
    }
    if (setuid(pwd->pw_uid) < 0) {
	fprintf(stderr, "cannot set group ID: %d\n", grp->gr_gid);
	exit(1);
    }
}
#endif

main(argc, argv)
int     argc;
char  **argv;
{
    static char shellch[] = "[]*?<>&^|`;{}()'\"\\";
    static char blnks[] = " \t\r\n";
    char   *cp;
    char   *args[BUFSIZ];
    char  **cpp = args;

    /* Allow the form "sh -c command" only. */

    if (argc != 3 || strcmp(argv[1], "-c") != 0) {
	fprintf(stderr, "usage: %s -c 'command'\n", argv[0]);
	exit(1);
    }

    /* Drop privileges if running privileged. */

#ifdef USER
    if (getuid() == 0)
	drop_privileges();
#endif
	
    /* We do not understand shell metacharacters and therefore refuse them. */

    if (cp = strpbrk(argv[2], shellch)) {
	fprintf(stderr, "%s: shell metacharacter ``%c'' does not work\n",
		argv[0], *cp);
	exit(1);
    }
    /* Split argv[2] at blanks. Beware of very long commands. */

    for (cp = strtok(argv[2], blnks); cp; cp = strtok((char *) 0, blnks)) {
	if (cpp < args + BUFSIZ - 1) {
	    *cpp++ = cp;
	} else {
	    fprintf(stderr, "%s: %s: too many command parameters\n",
		    argv[0], args[0]);
	    exit(1);
	}
    }
    *cpp = 0;

    /* Run the command or give up. */

    execvp(args[0], args);
    perror(args[0]);
    exit(1);
}
