/*
     fc - Filter compiler software for the Drawbridge package
     Copyright (C) 1993 David K. Hess, Douglas Lee Schales, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.
*/
#include <sys/types.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#include "chario.h"
#include "macros.h"
#include "services.h"
#include "groups.h"

extern int parse_error;

struct group_list *group_names = (struct group_list *)0;

void
init_groups(void)
{
     group_names = (struct group_list *)0;
}

void
make_group(char *grp)
{
     struct group_list *rove;

     for(rove = group_names;rove;rove=rove->next){
	  if(!strcmp(grp, rove->name)){
	       fprintf(stderr, "\"%s\", line %d: class %s already defined.\n",
		       getfilename(), getlinenum(), grp);
	       parse_error = 1;
	       break;
	  }
     }

     if(!rove){
	  struct group_list *new;

	  new = NEW(struct group_list);
	  if(!new){
	       fprintf(stderr, "%s, line %d: malloc failed\n",
		       __FILE__, __LINE__);
	       exit(1);
	  }

	  new->name = strdup(grp);
	  new->next = group_names;
	  new->fp = fp_head;
	  fp_head = 0;

	  group_names = new;
     }
}

struct group_list *
locate_group(char *grp)
{
     struct group_list *rove;

     for(rove = group_names;rove;rove=rove->next){
	  if(!strcmp(grp, rove->name))
	       break;
     }

     return rove;
}

void
push_group(char *grp)
{
     struct group_list *rove;

     rove = locate_group(grp);
     

     if(rove){
	  struct filt_protocols *fp_rove;
	  struct port_range *pr_rove;
	  struct service srv;
	  inout io;
	  srcdst sd;
	  accrej ar;
	  
	  for(fp_rove = rove->fp;fp_rove;fp_rove = fp_rove->fp_next){
	       FORBOTH(ar, FP_ACC, FP_REJ){
		    FORBOTH(io, FP_IN, FP_OUT){
			 FORBOTH(sd, FP_SRC, FP_DST){
			      pr_rove=fp_rove->fp_pr[ar][io][sd];
			      for(;pr_rove;pr_rove=pr_rove->pr_next){
				   srv.start = pr_rove->pr_start;
				   srv.end = pr_rove->pr_end;
				   srv.protocol = fp_rove->fp_id;
				   push_service(srv, io, sd, ar);
			      }
			 }
		    }
	       }
	  }
     }
     else {
	  fprintf(stderr, "\"%s\", line %d: undeclared group: %s\n",
		  getfilename(), getlinenum(), grp);
	  parse_error = 1;
     }
}
