.NH 1
INTRODUCTION
.NH 2
UNIX SECURITY
.FS
.SM UNIX
is a registered trademark of
.SM AT&T .
.SM VAX
is a trademark of Digital Equipment Corporation.
Sun-3 and
.SM NFS
are trademarks of Sun Microsystems.
Annex is a trademark of Xylogics, Inc.
.FE
.PP
The
.SM UNIX
operating system,
although now in widespread use in environments concerned about security,
was not really designed with security in mind [Ritc75].
This does not mean that
.SM UNIX
does not provide any security mechanisms;
indeed,
several very good ones are available.
However,
most ``out of the box'' installation procedures from companies such
as Sun Microsystems still install the operating
system in much the same way as it was installed 15 years ago:
with little or no security enabled.
.PP
The reasons for this state of affairs are largely historical.
.SM UNIX
was originally designed by programmers for use by other programmers.
The environment in which it was used was one of open cooperation,
not one of privacy.
Programmers typically collaborated with each other on projects,
and hence preferred to be able to share their files with each other
without having to climb over security hurdles.
Because the first sites outside of Bell Laboratories to install
.SM UNIX
were university research laboratories,
where a similar environment existed,
no real need for greater security was seen until some time later.
.PP
In the early 1980s,
many universities began to move their
.SM UNIX
systems out of the research laboratories and into the computer centers,
allowing (or forcing) the user population as a whole to use this new and
wonderful system.
Many businesses and government sites began to install
.SM UNIX
systems as well,
particularly as desktop workstations became more powerful and affordable.
Thus,
the
.SM UNIX
operating system is no longer being used only in environments where
open collaboration is the goal.
Universities require their students to use the system for class assignments,
yet they do not want the students to be able to copy from each other.
Businesses use their
.SM UNIX
systems for confidential tasks such as bookkeeping and payroll.
And the government uses
.SM UNIX
systems for various unclassified yet sensitive purposes.
.PP
To complicate matters,
new features have been added to
.SM UNIX
over the years,
making security even more difficult to control.
Perhaps the most problematic features are those
relating to networking:
remote login,
remote command execution,
network file systems,
diskless workstations,
and electronic mail.
All of these features have increased the utility and usability of
.SM UNIX
by untold amounts.
However,
these same features,
along with the widespread connection of
.SM UNIX
systems to the Internet and
other networks,
have opened up many new areas of vulnerability to
unauthorized abuse of the system.
.NH 2
THE INTERNET WORM
.PP
On the evening of November 2, 1988,
a self-replicating program,
called a
.I worm ,
was released on the Internet [Seel88, Spaf88, Eich89].
Overnight,
this program had copied itself from machine to machine,
causing the machines it infected to labor under huge loads,
and denying service to the users of those machines.
Although the program only infected two types of computers,*
.FS *
Sun-3 systems from Sun Microsystems and
.SM VAX
systems from Digital Equipment Corp.,
both running variants of 4.\fIx\fP
.SM "BSD UNIX"
from the University of California at Berkeley.
.FE
it spread quickly,
as did the concern,
confusion,
and sometimes panic of system administrators whose machines were affected.
While many system administrators were aware that something like this
could theoretically happen \-
the security holes exploited by the worm were well known \-
the scope of the worm's break-ins came as a great surprise to most people.
.PP
The worm itself did not destroy any files,
steal any information (other than account passwords),
intercept private mail,
or plant other destructive software [Seel88].
However,
it did manage to severely disrupt the operation of the network.
Several sites,
including parts of
.SM MIT ,
.SM NASA 's
Ames Research Center and Goddard Space Flight Center,
the Jet Propulsion Laboratory,
and the U. S. Army Ballistic Research Laboratory,
disconnected themselves from the Internet to avoid recontamination.
In addition,
the Defense Communications Agency ordered the connections between the
.SM MILNET
and
.SM ARPANET
shut down,
and kept them down for nearly 24 hours [Eich89, Elme88].
Ironically,
this was perhaps the worst thing to do,
since the first fixes to combat the worm were distributed via the network
[Eich89].
.PP
This incident was perhaps the most widely described computer security problem
ever.
The worm was covered in many newspapers and magazines around the country
including the
.I "New York Times" ,
.I "Wall Street Journal" ,
.I "Time"
and most computer-oriented technical publications,
as well as on all three major television networks,
the Cable News Network,
and National Public Radio.
In January 1990,
a United States District Court jury found Robert Tappan Morris,
the author of the worm,
guilty of charges brought against him under a 1986 federal computer
fraud and abuse law.
Morris faces up to five years in prison and a $250,000 fine [Schu90].
Sentencing is scheduled for May 4, 1990.
.NH 2
SPIES AND ESPIONAGE
.PP
In August 1986,
the Lawrence Berkeley Laboratory,
an unclassified research laboratory at the University of California at
Berkeley,
was attacked by an unauthorized computer intruder [Stol88, Stol89].
Instead of immediately closing the holes the intruder was using,
the system administrator,
Clifford Stoll,
elected to watch the intruder and document the weaknesses he exploited.
Over the next 10 months,
Stoll watched the intruder attack over 400 computers around the world,
and successfully enter about 30.
The computers broken into were located at universities,
military bases,
and defense contractors [Stol88].
.PP
Unlike many intruders seen on the Internet,
who typically enter systems and browse around to see what they can,
this intruder was looking for something specific.
Files and data dealing with the Strategic Defense Initiative,
the space shuttle,
and other military topics all seemed to be of special interest.
Although it is unlikely that the intruder would have found any truly
classified information (the Internet is an unclassified network),
it was highly probable that he could find a wealth of sensitive material
[Stol88].
.PP
After a year of tracking the intruder (eventually involving the
.SM FBI ,
.SM CIA ,
National Security Agency,
Air Force Intelligence,
and authorities in West Germany),
five men in Hannover, West Germany were arrested.
In March 1989,
the five were charged with espionage:
they had been selling the material they found during their exploits
to the
.SM KGB .
One of the men,
Karl Koch (``Hagbard''),
was later found burned to death in an isolated forest outside Hannover.
No suicide note was found [Stol89].
In February 1990,
three of the intruders
(Markus Hess,
Dirk Bresinsky,
and Peter Carl)
were convicted of espionage in a German court and sentenced to prison terms,
fines,
and the loss of their rights to participate in elections [Risk90].
The last of the intruders,
Hans Hu\*:bner (``Pengo''),
still faces trial in Berlin.
.NH 2
OTHER BREAK-INS
.PP
Numerous other computer security problems have occurred in recent years,
with varying levels of publicity.
Some of the more widely known incidents include
break-ins on
.SM NASA 's
.SM SPAN
network [McLe87],
the
.SM IBM
``Christmas Virus'' [Risk87],
a virus at Mitre Corp. that caused the
.SM MILNET
to be temporarily
isolated from other networks [Risk88],
a worm that penetrated
.SM DECNET
networks [Risk89a],
break-ins on U. S. banking networks [Risk89b],
and a multitude of viruses,
worms,
and trojan horses affecting personal
computer users.
.NH 2
SECURITY IS IMPORTANT
.PP
As the previous stories demonstrate,
computer security is an important topic.
This document describes the security features provided by the
.SM UNIX
operating system,
and how they should be used.
The discussion centers around version 4.\fIx\fP of
.SM OS , Sun
the version of
.SM UNIX
sold by Sun Microsystems.
Most of the information presented applies equally well to other
.SM UNIX
systems.
Although there is no way to make a computer completely secure against
unauthorized use (other than to lock it in a room and turn it off),
by following the instructions in this document you can make your system
impregnable to the ``casual'' system cracker,*
.FS *
The term ``hacker,'' as applied to computer users,
originally had an honorable connotation:
``a person who enjoys learning the
details of programming systems and how to stretch their capabilities -
as opposed to most users of computers,
who prefer to learn only the minimum amount necessary'' [Stee88].
Unfortunately,
the media has distorted this definition and given it a dishonorable
meaning.
In deference to the true hackers,
we will use the term ``cracker'' throughout this document.
.FE
and make it more difficult for the sophisticated cracker
to penetrate.
