;
;
;		NEA.ASM
;
;	NEW ENCRYPTION ALGORITHM
;
;	( 24 BIT KEY )
;
;	NEA.ASM IS AN 80X86 ASSEMBLY LANGUAGE SOURCE CODE FILE WHICH
;	IMPLEMENTS THE NEA ENCRYPTION ALGORITHM.  KEYP AND NEA ARE
;	THE TWO C CALLABLE ROUTINES WHICH IMPLEMENT THE NEA KEY
;	PRE-PROCESSING AND ENCRYPTION/DECRYPTION RESPECTIVELY.	THIS
;	FILE CAN BE ASSEMBLED USING VERSION 6.0 OF THE MICROSOFT MACRO
;	ASSEMBLER.  THE RESULTING OBJ FILE CAN BE LINKED TO A MEDIUM
;	MODEL MICROSOFT C PROGRAM.
;
;
	PAGE	,132
	.MODEL	MEDIUM,C
;
;	EQUATES
;
NO_TURNS EQU	4
NO_SBOXES EQU	(16 * NO_TURNS) 		;4 X 4 S BOXES
NO_PBOXES EQU	(NO_TURNS + 1)			;64 X 64 P BOXES
;
NO_LCSRNG EQU	128				;NUMBER OF LINEAR CONGRUENT
;						 SEQUENCE RANDOM NUMBER GENERATORS
;						 PER GROUP.  THERE ARE TWO GROUPS.
;
;
;	SET UP BOX GENERATION ROUTINE
;
;	GENERATES EITHER A PBOX OR AN SBOX
;
SUBXGN	MACRO	ADDRESS,LENGTH,FILTER
	MOV	SI,ADDRESS
	MOV	DL,LENGTH
	MOV	DH,FILTER			;FILTER LIMITS OUTPUTS TO (2**N) - 1
	CALL	GENBX
	ENDM
;
;
;	SET UP INVERSE BOX GENERATION ROUTINE
;
SUBXIV	MACRO	ADDRESS,INVERSE,LENGTH
	MOV	SI,ADDRESS
	MOV	DI,INVERSE
	MOV	CX,LENGTH
	CALL	GENIV
	ENDM
;
	.CODE
;
;
;		KEYP (KEY)
;
;	CHAR *KEY	ENCRYPTION KEY
;
;	PRE-PROCESSING OF KEY
;
;	KEYP FIRST CALLS EXP_KEY TO FORM THE SEEDS AND MULTIPLIERS
;	FOR THE TWO MASTER RANDOM NUMBER GENERATORS.  THESE MASTER
;	RNG'S ARE USED TO PRODUCE THE SEEDS AND MULTIPLIERS FOR THE
;	TWO GROUPS OF SECONDARY RNG'S.  THE 4 X 4 BIT S BOXES AND
;	THE 64 X 64 BIP P BOXES ARE THEN GENERATED ALONG WITH THEIR
;	INVERSES.
;
keyp	PROC	USES SI DI,KEY,PKEY,IPKEY
	PUSH	DS
	POP	ES
	CLD
;
	MOV	SI,KEY				;GET ROTATES AND MASTERS
	MOV	KEY_PTR,SI			;SAVE A POINTER TO THE KEY
	MOV	AL,[SI] 			;GET FIRST BYTE OF KEY
	AND	AL,07H				;GET 3 LSB'S
	MOV	ROT1,AL 			;SAVE AS ROTATION FOR INPUT AND OUTPUT
	MOV	AL,[SI]+2			;GET THIRD BYTE OF KEY
	AND	AL,07H				;GET 3 LSB'S
	MOV	ROT2,AL 			;SAVE AS ROTATION FOR INPUT AND OUTPUT
;
	MOV	SI,OFFSET P1			;BUILD FIRST MASTER
	MOV	DI,OFFSET MSEED1
	CALL	EXP_KEY 			;CALL EXP_KEY USING TABLE P1 TO FORM FIRST SEED AND MULT
;
	MOV	SI,OFFSET P2			;BUILD SECOND MASTER
	MOV	DI,OFFSET MSEED2
	CALL	EXP_KEY 			;CALL EXP_KEY USING TABLE P2 TO FORM SECOND SEED AND MULT
;						;PRIME MASTERS
	MOV	AX,MSEED1			;CYCLE FIRST MASTER
	MOV	BX,MMULT1
	MUL	BX
	ADD	AX,BX
	MOV	CL,AH
	AND	CX,3FH				;REDUCE RANDOM NUMBER OUTPUT MOD 2**5
	INC	CX				;ADD ONE TO VALUE
@@:	MUL	BX				;CYCLE THE MASTER THAT MANY TIMES
	ADD	AX,BX
	LOOP	@B
;
	MOV	CX,NO_LCSRNG * 4		;SET UP TO GENERATE SECONDARY RNG'S
	MOV	DI,OFFSET SEEDS2
@@:	MUL	BX				;CYCLE MASTER
	ADD	AX,BX
	XCHG	AH,AL
	STOSB					;SAVE BYTE
	XCHG	AH,AL
	LOOP	@B
	MOV	MSEED1,AX			;SAVE MASTER
	MOV	MMULT1,BX
;
	MOV	CX,NO_LCSRNG			;ADJUST MULTIPLIERS
	MOV	SI,OFFSET MULTS2
	MOV	DI,SI
@@:	LODSW					;GET MULTIPLIER
	AND	AX,0FFF8H			;SET MULTIPLIER MOD 8 = 5
	OR	AX,05H
	STOSW					;SAVE MULTIPLIER
	LOOP	@B
;						;CYCLE SECONDARY GENERATORS INTO THEIR SEQUENCES
	MOV	SI,OFFSET SEEDS2		;POINT TO SEEDS/VALUES
	MOV	DI,SI
PRLP1:	MOV	BX,[SI] + (2 * NO_LCSRNG)	;POINT TO MULTIPLIERS
	LODSW					;GET VALUE
	MUL	BX				;CYCLE GENERATOR
	ADD	AX,BX
	MOV	CL,AH
	AND	CX,3FH				;REDUCE RANDOM NUMBER MOD 2**5
	INC	CX				;INCREMENT VALUE
@@:	MUL	BX				;CYCLE SECONDARY GENERATOR THAT MANY TIMES
	ADD	AX,BX
	LOOP	@B
	STOSW					;SAVE NEW VALUE
	CMP	SI,OFFSET MULTS2		;ALL GENERATORS IN GROUP DONE?
	JB	PRLP1
;
;						;NOW REPEAT EVERYTHING FOR THE SECOND
;						;MASTER AND THE SECOND SET OF SECONDARY RNG'S
	MOV	AX,MSEED2			;CYCLE SECOND MASTER
	MOV	BX,MMULT2
	MUL	BX
	ADD	AX,BX
	MOV	CL,AH
	AND	CX,3FH				;REDUCE RANDOM NUMBER OUTPUT MOD 2**5
	INC	CX				;ADD ONE TO VALUE
@@:	MUL	BX				;CYCLE THE MASTER THAT MANY TIMES
	ADD	AX,BX
	LOOP	@B
;
	MOV	CX,NO_LCSRNG * 4		;SET UP TO GENERATE SECONDARY RNG'S
	MOV	DI,OFFSET SEEDS1
@@:	MUL	BX				;CYCLE MASTER
	ADD	AX,BX
	XCHG	AH,AL
	STOSB					;SAVE BYTE
	XCHG	AH,AL
	LOOP	@B
	MOV	MSEED2,AX			;SAVE MASTER
	MOV	MMULT2,BX
	MOV	CX,NO_LCSRNG
	MOV	SI,OFFSET MULTS1		;ADJUST MULTIPLIERS
	MOV	DI,SI
@@:	LODSW
	AND	AX,0FFF8H			;GET MULTIPLIER
	OR	AX,05H				;SET MULTIPLIER MOD 8 = 5
	STOSW
	LOOP	@B				;SAVE MULTIPLIER
;												    ;OFFSET SECONDARY GENERATORS INTO
;						;CYCLE SECONDARY GENERATORS INTO THEIR SEQUENCES    ;THEIR CYCLES
	MOV	SI,OFFSET SEEDS1		;POINT TO SEEDS/VALUES				    ;POINT TO SEED/VALUE
	MOV	DI,SI
PRLP2:	MOV	BX,[SI] + (2 * NO_LCSRNG)	;POINT TO MULTIPLIERS				    ;GET MULTIPLIER
	LODSW					;GET VALUE					    ;GET SEED
	MUL	BX				;CYCLE GENERATOR				    ;CYCLE SECONDARY GENERATOR
	ADD	AX,BX
	MOV	CL,AH
	AND	CX,3FH				;REDUCE RANDOM NUMBER MOD 2**5			    ;REDUCE THE RANDOM VALUE MOD 2**5
	INC	CX				;INCREMENT VALUE				    ;INCREMENT VALUE
@@:	MUL	BX				;CYCLE SECONDARY GENERATOR THAT MANY TIMES	    ;CYCLE THE GENERATOR THAT MANY TIMES
	ADD	AX,BX
	LOOP	@B
	STOSW					;SAVE NEW VALUE
	CMP	SI,OFFSET MULTS1		;ALL GENERATORS IN GROUP DONE?			    ;CHECK IF THIS GROUP IS DONE
	JB	PRLP2
	MOV	RNGSW,0 			;PRIME GROUP SELECTOR SWITCH
;
;						;BUILD PBOXES
	MOV	PPTR,OFFSET PBOXES		;POINT TO FIRST PBOX
	MOV	IPPTR,OFFSET IPBOXES + (NO_PBOXES * 64) - 64	;POINT TO LAST INVERSE PBOX
@@:	SUBXGN	PPTR,64,03FH			;GENERATE PBOX
	SUBXIV	PPTR,IPPTR,64			;GENERATE INVERSE
	MOV	AX,IPPTR			;NEXT BOX
	CMP	AX,OFFSET IPBOXES		;ALL DONE?
	JE	SBXS				;YES - DO SBOX'S
	SUB	AX,64				;NO - NEXT PBOX
	MOV	IPPTR,AX			;NEXT INVERSE GOS AHEAD OF LAST
	MOV	AX,PPTR
	ADD	AX,64				;NEXT BOX GOS AFTER LAST
	MOV	PPTR,AX
	JMP	@B
;						;BUILD SBOX'S
SBXS:	MOV	SPTR,OFFSET SBOXES		;POINT TO FIRST BOX
	MOV	ISPTR,OFFSET ISBOXES + (NO_SBOXES * 16) - 256	;POINT TO LAST INVERSE SBOX
GSBXLP: MOV	CUR_SBOX,0			;INITIALIZE INDEX
@@:	SUBXGN	SPTR,16,0FH			;GENERATE SBOX
	SUBXIV	SPTR,ISPTR,16			;GENERATE INVERSE
	ADD	SPTR,16 			;NEXT SBOX FOR THIS TURN
	ADD	ISPTR,16			;NEXT INVERSE FOR THIS TURN
	INC	CUR_SBOX			;INCREMENT INDEX
	CMP	CUR_SBOX,16			;THIS TURN DONE?
	JNE	@B				;NO - NEXT SBOX IN GROUP
	CMP	ISPTR,OFFSET ISBOXES + 256	;YES - ALL DONE?
	JE	KEYPEX				;YES - EXIT
	SUB	ISPTR,512			;NO - NEXT INVERSE GROUP GOS BEFORE LAST
	JMP	GSBXLP
;
KEYPEX: RET					;EXIT
keyp	ENDP
;
;
;		NEA (INAD,OTAD,ED)
;
;	CHAR *INAD	INPUT DATA ADDRESS
;	CHAR *OTAD	OUTPUT DATA ADDRESS
;	INT  ED 	ENCRYPT (1) /DECRYPT (0) SWITCH
;
;	ENCRYPTS/DECRYPTS
;
;	ENCRYPTS OR DECRYPTS A 64 BIT (8 BYTE) DATA BLOCK POINTED
;	TO BY INAD AND STORES THE RESULT IN THE BLOCK POINTED TO
;	BY OTAD.  INAD AND OTAD CAN POINT TO THE SAME BLOCK.
;	THE 8 BYTES ARE FIRST LOGICALLY ROTATED BY VALUES DERIVED
;	FROM THE KEY. THE BYTES ARE THEN PERMUTED BY A FIRST 64 X 64
;	BIT P BOX. THE DATA FIELD IS THEN BROKEN DOWN INTO 16 4 BIT
;	NIBBLES WHICH ARE EACH ACTED ON BY A 4 X 4 BIT S BOX.
;	THE PERMUTATION-SUBSTITUTION IS THEN REPEATED WITH DIFFERENT
;	RANDOMLY GENERATED P AND S BOXES NO_TURNS TIMES.
;	AFTER A FINAL PERMUTATION, THE DATA BYTES ARE ROTATED THE
;	OPPOSITE DIRECTION OF THE INPUT PERMUTATION BEFORE IT IS OUTPUT.
;
nea	PROC	USES SI DI,INAD,OTAD,ED
	PUSH	DS
	POP	ES
;
	MOV	SI,INAD 			;GET DATA
	MOV	DI,OFFSET DATA			;STORE IN "DATA"
	MOV	CX,8
REP	MOVSB
;
	MOV	CL,ROT1 			;ROTATE DATA
	ROL	DATA,CL 			;FIRST BYTE TO LEFT BY ROT1
	ROR	DATA+5,CL			;SIXTH BYTE TO RIGHT BY ROT1
	ROL	DATA+6,CL			;SEVENTH BYTE TO LEFT BY ROT1
	ROR	DATA+7,CL			;EIGHTH BYTE TO RIGHT BY ROT1
	MOV	CL,ROT2
	ROR	DATA+1,CL			;SECOND BYTE TO RIGHT BY ROT2
	ROL	DATA+2,CL			;THIRD BYTE TO LEFT BY ROT2
	ROL	DATA+3,CL			;FORTH BYTE TO LEFT BY ROT2
	ROR	DATA+4,CL			;FIFTH BYTE TO RIGHT BY ROT2
;
	MOV	TURN,0				;INITIALIZE TURN COUNT
	MOV	AX,ED				;ENCRYPT OR DECRYPT?
	OR	AX,AX
	JNZ	@F
	MOV	PPTR,OFFSET PBOXES		;ENCRYPT
	MOV	SPTR,OFFSET SBOXES		;INITIALIZE PA ND S BOX POINTERS
	JMP	FIRSTP
@@:	MOV	PPTR,OFFSET IPBOXES		;DECRYPT
	MOV	SPTR,OFFSET ISBOXES		;USE POINTERS TO INVERSE BOXES
;
FIRSTP: MOV	DX,PPTR 			;FIRST PBOX
	CALL	PBOX				;DO FIRST PERMUTATION
	ADD	PPTR,64 			;POINT TO NEXT PBOX TABLE
;
NEALP:	MOV	CL,4				;SBOX - DO 16  4 X 4 S BOXES
	MOV	BX,SPTR 			;GET POINTER TO SBOX'S
	MOV	SI,OFFSET DATA			;POINT TO DATA
	MOV	DI,SI
	MOV	TEMP,0				;INITIALIZE BYTE COUNT
SBOX:	LODSB					;GET DATA BYTE
	MOV	DL,AL				;SAVE INPUT DATA
	SHR	AL,CL				;ISOLATE LEFT NIBBLE
	XLAT					;DO SUBSTITUTION!
	ADD	BX,16				;POINT TO NEXT SBOX
	SHL	AL,CL				;REPOSITION SUBSTITUTED NIBBLE
	MOV	DH,AL				;SAVE HIGH NIBBLE
	MOV	AL,DL				;GET SAVED INPUT BYTE
	AND	AL,0FH				;ISOLATE RIGHT NIBBLE
	XLAT					;DO SUBSTITUTION!
	ADD	BX,16				;POINT TO NEXT SBOX
	OR	AL,DH				;COMBINE RESULTS TO FORM OUTPUT
	STOSB					;STORE OUTPUT BYTE
	INC	TEMP				;INCREMENT BYTE COUNT
	CMP	TEMP,8				;LAST BYTE OF EIGHT?
	JNE	SBOX				;NO - DO NEXT BYTE
	ADD	SPTR,256			;YES - POINT TO NEXT GROUP OF 16 SBOX'S
;
	MOV	DX,PPTR 			;DO PERMUTATION FOR THIS TURN
	CALL	PBOX				;PBOX
	ADD	PPTR,64 			;POINT TO NEXT PBOX
;
	INC	TURN				;CHECK IF DONE
	CMP	TURN,NO_TURNS
	JNE	NEALP				;DO NEXT TURN
;
	MOV	CL,ROT1 			;ROTATE DATA
	ROR	DATA,CL 			;FIRST BYTE TO RIGHT BY ROT1
	ROL	DATA+5,CL			;SIXTH BYTE TO LEFT BY ROT1
	ROR	DATA+6,CL			;SEVENTH BYTE TO RIGHT BY ROT1
	ROL	DATA+7,CL			;EIGHTH BYTE TO LEFT BY ROT1
	MOV	CL,ROT2
	ROL	DATA+1,CL			;SECOND BYTE TO LEFT BY ROT2
	ROR	DATA+2,CL			;THIRD BYTE TO RIGHT BY ROT2
	ROR	DATA+3,CL			;FORTH BYTE TO RIGHT BY ROT2
	ROL	DATA+4,CL			;FIFTH BYTE TO LEFT BY ROT2
;
	MOV	DI,OTAD 			;STORE RESULT
	MOV	SI,OFFSET DATA
	MOV	CX,8
REP	MOVSB
;
	RET					;EXIT
nea	ENDP
;
;
;		EXP_KEY
;
;	EXPANDS KEY ARRAY TO 32 BITS.  THIS IS ESSENTIALLY
;	AN EXPANSION P BOX USING TABLE P1 OR P2.  THE OUTPUT
;	IS USED TO FORM THE SEED AND MULTIPLIER OF ONE OF THE
;	TWO MASTER LCS RANDOM NUMBER GENERATORS.
;
;	CX - COUNT OF BITS IN KEY
;	DH - TARGET MASK BIT
;	BX - POINTER TO KEY BYTE (INPUT)
;	SI - POINTER TO PERMUTATION TABLE
;	DI - POINTER TO SEED/MULTIPLIER BYTES (OUTPUT)
;
EXP_KEY PROC
	XOR	AH,AH
	MOV	BYTE PTR [DI],0 		;RESET OUTPUT
	MOV	BYTE PTR [DI+1],0
	MOV	BYTE PTR [DI+2],0
	MOV	BYTE PTR [DI+3],05H		;MULTIPLIER MOD 8 = 5
	MOV	CX,29				;COUNT OF BYTES IN SEED/MULT
	MOV	DH,80H				;INITIALIZE BIT SET MASK
LOP:	LODSB					;GET FIRST TABLE ELEMENT
	MOV	BX,KEY_PTR			;GET POINTER TO KEY BYTE
	ADD	BX,AX				;INDEX BY TABLE ELEMENT
	LODSB					;GET KEY BIT MASK
	TEST	[BX],AL 			;IS IT A ONE?
	JZ	@F
	OR	[DI],DH 			;YES - SET SEED/MULT BIT
@@:	SHR	DH,1				;NEXT BIT OF SEED/MULT
	JNC	@F
	INC	DI				;NEXT WORD OF SEED/MULT
	MOV	DH,80H				;RESET MASK
@@:	LOOP	LOP				;DONE?
	MOV	AX,[DI-1]			;ADJUST MULTIPLIER FOR "INTEL-ENDIAN"
	XCHG	AL,AH
	MOV	[DI-1],AX
	RET
EXP_KEY ENDP
;
;
;		GNRND
;
;	GENERATES RANDOM BYTE IN AL
;
;	THE LEAST SIGNIFICANT BIT OF RNGSW IS USED TO SELECT
;	ONE OF THE MASTER RANDOM NUMBER GENERATORS AND ONE OF
;	THE SETS OF LCS RANDOM NUMBER GENERATORS.  THE MASTER
;	RNG IS CYCLED AND ITS OUTPUT IS TAKEN MODULO THE NUMBER
;	OF RNG'S IN THE GROUP.  THE RNG WHITH THAT INDEX IS CYCLED
;	AND ITS OUTPUT IS USED AS THE RETURN VALUE.
;
GNRND	PROC	PRIVATE USES SI DI BX DX
	TEST	RNGSW,1 			;SELECT MASTER
	JZ	@F
	MOV	AX,MSEED1			;CYCLE MASTER 1
	MOV	BX,MMULT1
	MUL	BX
	ADD	AX,BX
	MOV	MSEED1,AX			;REPLACE WITH NEW VALUE
	JMP	GETRND
;
@@:	MOV	AX,MSEED2			;CYCLE MASTER 2
	MOV	BX,MMULT2
	MUL	BX
	ADD	AX,BX
	MOV	MSEED2,AX			;REPLACE WITH NEW VALUE
;
GETRND: MOV	AL,AH				;GET GENERATOR
	XOR	AH,AH				;8 MSB'S ARE RANDOM VALUE
	AND	AL,NO_LCSRNG - 1		;REDUCE MODULO NUMBER OF RNG'S IN GROUP
	SHL	AX,1				;CONVERT TO WORD INDEX
	MOV	SI,AX
	ADD	SI,OFFSET SEEDS1		;POINT TO LAST VALUE OF GENERATOR
	TEST	RNGSW,1
	JNZ	@F				;SECOND GROUP OF RNG'S?
	ADD	SI,NO_LCSRNG * 4		;YES - ADD OFFSET SO THAT SECOND GROUP IN POINTED TO
@@:	MOV	DI,SI
	MOV	BX,[SI] + (NO_LCSRNG * 2)	;GET MULTIPLIER
	LODSW
	MUL	BX				;CYCLE GENERATOR
	ADD	AX,BX
	STOSW					;REPLACE WITH NEW VALUE
	MOV	RNGSW,AL			;NEW RNGSW
	MOV	AL,AH				;8 MSB'S ARE RANDOM VALUE
	XOR	AH,AH
	RET					;EXIT
GNRND	ENDP
;
;		GENBX
;
;	GENERATE BOX
;
;	GENERATES A PBOX OR SBOX USING THE OUTPUT OF
;	THE RANDOM NUMBER GENERATOR.  ON INPUT SI POINTS TO
;	THE OUTPUT FIELD, DL HAS THE NUMBER OF ELEMENTS IN
;	THE BOX, AND DH HAS A "FILTER" WHICH LIMITS THE SIZE
;	OF THE INDIVIDUAL TABLE ELEMENTS.
;
GENBX	PROC	PRIVATE
	XOR	BX,BX				;CLEAR OUTPUT INDEX
	XOR	CX,CX
	CALL	GNRND				;GET RANDOM BYTE AND GENERATE FIRST ELEMENT
	AND	AL,DH				;USE FILTER TO LIMIT SIZE OF ELEMENT
	MOV	[SI+BX],AL			;STORE FIRST ELEMENT
GNBXLP: INC	BX				;NEXT ELEMENT
	CMP	BL,DL				;DONE?
	JE	GNBXEX
@@:	CALL	GNRND				;GET RANDOM BYTE
	AND	AL,DH				;USE FILTER TO LIMIT SIZE OF ELEMENT
	MOV	CX,BX				;DUPLICATE?
	MOV	DI,SI
REPNE	SCASB					;HAS THIS RANDOM NUMBER BEEN USED?
	JE	@B				;YES - TRY AGAIN
	MOV	[SI+BX],AL			;NO - STORE AS NEXT ELEMENT IN BOX TABLE
	JMP	GNBXLP
;
GNBXEX: RET					;EXIT
GENBX	ENDP
;
;		GENIV
;
;	GENERATE INVERSE BOX
;
;	GENERATES THE INVERSE OF A P BOX OR S BOX.
;	ON ENTRY SI HAS ADDRESS OF INPUT BOX, DI POINTS
;	TO INVERSE BOX DESTINATION, AND CX HAS THE NUMBER
;	OF ELEMENTS IN BOX.
;
GENIV	PROC	PRIVATE
	XOR	BH,BH
	XOR	DL,DL				;INITIALIZE INPUT INDEX
@@:	LODSB					;GET INPUT BOX ELEMENT
	MOV	BL,AL				;USE INPUT ELEMENT AS INDEX INTO OUTPUT TABLE
	MOV	[BX+DI],DL			;OUTPUT VALUE IS INDEX OF INPUT ELEMENT
	INC	DL				;INCREMENT INPUT INDEX
	LOOP	@B
	RET
GENIV	ENDP
;
;		PBOX
;
;	PERMUTATION BOX
;
;	PERMUTES 64 BIT FIELD IN "DATA".
;	ON ENTRY DX POINTS TO A 64 ELEMENT PERMUTATION TABLE
;
PBOX	PROC	PRIVATE
	MOV	SI,OFFSET DATA
	MOV	DI,OFFSET TEMP			;CLEAR TEMP
	MOV	CX,8
	XOR	AL,AL
REP	STOSB
	MOV	DI,DX				;GET TABLE ADDRESS
	XOR	BH,BH
	XOR	CH,CH				;RESET COUNT
;
PLOOP:	MOV	AH,80H				;RESET MASK USED TO TEST INPUT BIT
	LODSB					;GET INPUT BYTE
NXBIT:	TEST	AL,AH				;TEST BIT
	JZ	@F				;IF INPUT BIT IS ZERO, GO TO NEXT BIT
	MOV	BL,CH				;GET TABLE ENTRY
	MOV	DL,[DI+BX]			;DL NOW HAS BIT NUMBER TO SET (0 - 63)
	XOR	DH,DH
	MOV	CL,5				;BREAK INTO BYTE/BIT
	SHL	DX,CL				;2 BIT WORD INDEX IN DH
	SHR	DL,CL				;3 BIT BYTE INDEX IN DL
	MOV	BL,DH				;SET BIT IN TEMP
	MOV	DH,80H				;PREPARE SETTING MASK
	MOV	CL,DL
	SHR	DH,CL				;PROPER '1' BIT IS SET IN DH
	OR	BYTE PTR [BX+OFFSET TEMP],DH	;SET OUTPUT BIT IN TEMP
@@:	INC	CH				;INCREMENT COUNT, GO TO NEXT INPUT BIT
	CMP	CH,64				;CHECK IF DONE
	JE	@F
	CLC
;
	RCR	AH,1				;NEXT BIT OF INPUT BYTE
	JNC	NXBIT				;LSB DONE?
	JMP	PLOOP				;YES - NEXT BYTE
;
@@:	MOV	DI,OFFSET DATA			;MOVE TEMP TO DATA
	MOV	SI,OFFSET TEMP
	MOV	CX,8
REP	MOVSB					;EXIT
	RET
PBOX	ENDP
;
;
	.DATA
;
KEY_PTR DW	?				;POINTER TO KEY
;
DATA	DB	8 DUP (?)			;INPUT DATA WORDS
TEMP	DB	8 DUP (?)
;
PBOXES	DB	NO_PBOXES * 64 DUP (?)		;64 X 64 P BOXES
IPBOXES DB	NO_PBOXES * 64 DUP (?)		;INVERSE P BOXES
SBOXES	DB	NO_SBOXES * 16 DUP (?)		;4 X 4 S BOXES
ISBOXES DB	NO_SBOXES * 16 DUP (?); 	;INVERSE S BOXES
;
ROT1	DB	?				;ROTATION 1
ROT2	DB	?				;ROTATION 2
CUR_SBOX DB	?
CUR_PBOX DB	?
SPTR	DW	0				;SBOX POINTER
ISPTR	DW	0
PPTR	DW	0				;PBOX POINTER
IPPTR	DW	0
;
;
MSEED1	DW	?				;MASTER SEED/CURRENT VALUE 1
MMULT1	DW	?				;MASTER MULT 1
MSEED2	DW	?				;MASTER SEED/CURRENT VALUE 2
MMULT2	DW	?				;MASTER MULT 2
;
SEEDS1	DW	NO_LCSRNG DUP (?)		;RNG SEEDS/CURRENT VALUES
MULTS1	DW	NO_LCSRNG DUP (?)		;RNG MULTIPLIERS
SEEDS2	DW	NO_LCSRNG DUP (?)		;RNG SEEDS/CURRENT VALUES
MULTS2	DW	NO_LCSRNG DUP (?)		;RNG MULTIPLIERS
;
RNGSW	DB	0				;RANDOM GENERATOR SWITCH
TURN	DB	0
;
;	P1 AND P2 DEFINE THE EXPANSION P BOXS WHICH EXPAND THE KEY
;	TO 64 BITS.
;	THE TABLE IS ORDERED IN PAIRS OF BYTES, THE FIRST BYTE DEFINES
;	THE POSITION OF THE INPUT KEY BYTE, THE SECOND TABLE BYTE IS A
;	MASK WHICH SELECTS A PARTICULAR BIT.
;
P1	DB	2,4,1,32,2,128,2,16,0,8,1,1,0,64,1,64,2,64,2,2,1,4
	DB	2,4,0,16,0,1,2,2,1,1,0,4,1,16,2,16,2,32,1,16,1,2,0,128
	DB	2,8,1,128,2,1,1,8,1,1,0,32
;
P2	DB	1,32,2,64,1,2,2,1,0,128,0,32,0,2,2,8,0,64,1,16,1,1
	DB	2,2,0,8,1,8,1,64,0,1,2,128,2,32,0,16,2,4,1,8,2,32
	DB	2,2,2,64,2,1,2,16,1,128,0,4
;
	END
