webpackJsonp([6],{

/***/ 162:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2017 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Page to inform the user when a database reset is required.
 *
 * @author Florian Dold
 */
const React = __webpack_require__(1);
const ReactDOM = __webpack_require__(3);
const wxApi = __webpack_require__(2);
class State {
}
class ResetNotification extends React.Component {
    constructor(props) {
        super(props);
        this.state = { checked: false, resetRequired: true };
        setInterval(() => this.update(), 500);
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield wxApi.checkUpgrade();
            this.setState({ resetRequired: res.dbResetRequired });
        });
    }
    render() {
        if (this.state.resetRequired) {
            return (React.createElement("div", null,
                React.createElement("h1", null, "Manual Reset Reqired"),
                React.createElement("p", null,
                    "The wallet's database in your browser is incompatible with the ",
                    " ",
                    "currently installed wallet.  Please reset manually."),
                React.createElement("p", null, "Once the database format has stabilized, we will provide automatic upgrades."),
                React.createElement("input", { id: "check", type: "checkbox", checked: this.state.checked, onChange: (e) => this.setState({ checked: e.target.checked }) }),
                " ",
                React.createElement("label", { htmlFor: "check" }, "I understand that I will lose all my data"),
                React.createElement("br", null),
                React.createElement("button", { className: "pure-button", disabled: !this.state.checked, onClick: () => wxApi.resetDb() }, "Reset")));
        }
        return (React.createElement("div", null,
            React.createElement("h1", null, "Everything is fine!"),
            "A reset is not required anymore, you can close this page."));
    }
}
document.addEventListener("DOMContentLoaded", () => {
    ReactDOM.render(React.createElement(ResetNotification, null), document.getElementById("container"));
});


/***/ })

},[162]);
//# sourceMappingURL=reset-required-bundle.js.map